#import <GNUstepGUI/GSDisplayServer.h>
#import <X11/Xatom.h>
#import <X11/Xutil.h>
#import "AZTest.h"

@interface GSDisplayServer (AZPrivate)
- (void) processEvent: (XEvent *) event;
@end

static AZTest *sharedInstance;

@implementation AZTest

- (void)receivedEvent:(void *)data
                 type:(RunLoopEventType)type
                extra:(void *)extra
              forMode:(NSString *)mode
{
  XEvent event;

  while (XPending(dpy)) 
  {
    XNextEvent (dpy, &event);
    [server processEvent: &event];
  }
}

- (void) applicationWillFinishLaunching:(NSNotification *)aNotification
{
  server = GSCurrentServer();

  dpy = (Display*)[server serverDevice];
  screen = [[NSScreen mainScreen] screenNumber];
  root_win = RootWindow(dpy, screen);

  /* Listen event */
  NSRunLoop     *loop = [NSRunLoop currentRunLoop];
  int xEventQueueFd = XConnectionNumber(dpy);

  [loop addEvent: (void*)(gsaddr)xEventQueueFd
                        type: ET_RDESC
                     watcher: (id<RunLoopEvents>)self
                     forMode: NSDefaultRunLoopMode];
}

- (void) applicationDidFinishLaunching:(NSNotification *)aNotification
{
  /* Setup main window */
  int x = 10, y = 10, w = 300, h = 300, border_width = 10;
  mainXWindow = XCreateWindow(dpy, root_win, x, y, w, h, border_width,
		  CopyFromParent, CopyFromParent, CopyFromParent, 0, NULL);
  XSetWindowBackground(dpy, mainXWindow, BlackPixel(dpy, 0));

  /* Setup drawable window */
  x = 10, y = 10, w = 280, h = 280, border_width = 0;
  drawableXWindow = XCreateWindow(dpy, mainXWindow, x, y, w, h, border_width,
		  CopyFromParent, CopyFromParent, CopyFromParent, 0, NULL);
  XSetWindowBackground(dpy, drawableXWindow, WhitePixel(dpy, 0));

  XMapWindow(dpy, drawableXWindow);
  XMapWindow(dpy, mainXWindow);
  XFlush(dpy);

}

+ (AZTest *) sharedTest
{
  if (sharedInstance == nil)
    sharedInstance = [[AZTest alloc] init];
  return sharedInstance;
}

@end

