#import <Foundation/Foundation.h>
#include <bfd.h>

@interface GSFunctionInfo : NSObject
{
	void*    _address;
	NSString *_fileName;
	NSString *_functionName;
	int       _lineNo;
}
- initWithAddress:(void*)address 
             file:(NSString*)file 
         function:(NSString*)function 
             line:(int)lineNo;

- (void*) address;
- (int) lineNumber;
- (NSString *) fileName;
- (NSString *) function;

@end


@interface GSBinaryFileInfo : NSObject
{
	NSString * _filename;
	bfd     *_abfd;
	asymbol **_symbols;
	long    _symbolCount;
}
// return info for an executable (.EXE or .DLL) 
// but not for any of its dependency (i.e. required DLL)
- initWithBinaryFile: (NSString *)filename;
- init; // return info for the current executing process

- (NSString *) filename;

- (GSFunctionInfo *) functionForAddress: (void*) address;

@end


@interface GSStackTrace : NSObject
{
	NSMutableArray *frames;
}
// initialize stack trace info
+ (void) loadModule:(NSString *)filename;

// query the stack
+ (GSStackTrace*) currentStack;

- (unsigned) frameCount;
- (GSFunctionInfo*) frameAt:(unsigned) index;

- (NSString*) description;

- (NSEnumerator*) enumerator;
- (NSEnumerator*) reverseEnumerator;

@end
