package testResourceException;

import org.restlet.Application;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.Router;

public class TestApplication extends Application {

    /**
     * Constructor.
     * 
     * @param context
     *            Application's context.
     * @param customizedStatusService
     *            True in order to us a customized status filter.
     */
    public TestApplication(Context context, boolean customizedStatusService) {
        super(context);
        if (customizedStatusService) {
            this.setStatusService(new TestStatusService(true));
        }
    }

    @Override
    public Restlet createRoot() {
        Router router = new Router(getContext());
        router.attachDefault(TestResource.class);
        return router;
    }

}
