package testResourceException;

import org.restlet.Client;
import org.restlet.Component;
import org.restlet.data.Protocol;
import org.restlet.data.Response;

public class TestComponent extends Component {

    public static void main(String[] args) throws Exception {
        Component component = new TestComponent();
        component.getServers().add(Protocol.HTTP, 8182);

        component.getDefaultHost().attach(
                "/standard",
                new TestApplication(
                        component.getContext().createChildContext(), false));
        component.getDefaultHost().attach(
                "/customized",
                new TestApplication(
                        component.getContext().createChildContext(), true));
        component.start();

        Client client = new Client(Protocol.HTTP);
        Response response = client.get("http://localhost:8182/standard");
        response.getEntity().write(System.out);

        response = client.get("http://localhost:8182/customized");
        response.getEntity().write(System.out);
        component.stop();
    }
}
