package testResourceException;

import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.StringRepresentation;
import org.restlet.service.StatusService;

/**
 * Provide a customized status page.
 * 
 */
public class TestStatusService extends StatusService {

    public TestStatusService(boolean enabled) {
        super(enabled);
    }

    @Override
    public Representation getRepresentation(Status status, Request request,
            Response response) {
        final StringBuilder sb = new StringBuilder();
        sb.append("<html><head><title>Status page</title></head><body>");
        sb.append("<h3>");
        if (status.getDescription() != null) {
            sb.append(status.getDescription());
        } else {
            sb.append("No description available for this result status");
        }
        sb.append("</h3>");
        sb.append("<p>This is a customized status page</p></body></html>");

        return new StringRepresentation(sb.toString(), MediaType.TEXT_HTML);
    }

}
