package templateCustomized;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.restlet.util.Template;

public class MyTemplate extends Template {

    private Pattern regExpPattern;

    public MyTemplate(String pattern, int matchingMode, int defaultType,
            String defaultDefaultValue, boolean defaultRequired,
            boolean defaultFixed) {
        super(pattern, matchingMode, defaultType, defaultDefaultValue,
                defaultRequired, defaultFixed);
        this.regExpPattern = Pattern.compile(pattern);
        setMatchingMode(MODE_EQUALS);
    }

    public MyTemplate(String pattern, int matchingMode) {
        super(pattern, matchingMode);
        this.regExpPattern = Pattern.compile(pattern);
        setMatchingMode(MODE_EQUALS);
    }

    public MyTemplate(String pattern) {
        super(pattern);
        this.regExpPattern = Pattern.compile(pattern);
        setMatchingMode(MODE_EQUALS);
    }

    /**
     * Used for the routing process
     */
    @Override
    public int match(String formattedString) {
        int result = -1;

        try {
            if (formattedString != null) {
                final Matcher matcher = this.regExpPattern
                        .matcher(formattedString);

                if (matcher.matches()) {
                    result = matcher.end();
                }
            }
        } catch (final StackOverflowError soe) {
            getLogger().warning(
                    "StackOverflowError exception encountered while matching this string : "
                            + formattedString);
        }

        return result;
    }

    /**
     * Used to parse the reference and set the variables as request attributes.
     */
    @Override
    public int parse(String formattedString, Map<String, Object> variables) {
        int result = -1;

        if (formattedString != null) {
            try {

                final Matcher matcher = this.regExpPattern
                        .matcher(formattedString);
                final boolean matched = matcher.matches();

                // Catch the variable
                if (matched && matcher.groupCount() == 1) {
                    // Update the number of matched characters
                    result = matcher.end();
                    variables.put("attribute_name", matcher.group(1));
                }
            } catch (final StackOverflowError soe) {
                getLogger().warning(
                        "StackOverflowError exception encountered while matching this string : "
                                + formattedString);
            }
        }

        return result;
    }

}
