package templateCustomized;

import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.Route;
import org.restlet.Router;
import org.restlet.data.Protocol;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.StringRepresentation;

public class TestTemplate {
    public static void main(String[] args) throws Exception {
        Component component = new Component();
        component.getServers().add(Protocol.HTTP, 8182);

        Application application = new Application(component.getContext()) {
            @Override
            public Restlet createRoot() {
                Router router = new Router(getContext());
                Restlet restlet = new Restlet() {
                    @Override
                    public void handle(Request request, Response response) {
                        response
                                .setEntity(new StringRepresentation("OK"
                                        + request.getAttributes().get(
                                                "attribute_name")));
                        response.setStatus(Status.SUCCESS_OK);
                    }
                };

                router.getRoutes().add(
                        new Route(router, new MyTemplate(
                                "/file/([a-z]3-[0-9]5)\\.[a-z]+"), restlet));
                return router;
            }

        };

        component.getDefaultHost().attachDefault(application);
        component.start();
        String url = "http://localhost:8182/file/e3-15.txt";
        Client client = new Client(Protocol.HTTP);
        client.get(url).getEntity().write(System.out);
        component.stop();
    }
}
