#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <alloca.h>


#include "core_functions.h"
#include "caller.h"
#include "file_functions.h"


#define ERR_OP_NOT_DEFINED \
		"Operation not defined\n"
#define ERR_INVALID_NO_OF_PARAMS \
		"Incorrect number of parameters for operation selected.\n"
#define ERR_INTERFACES_FILE_NAME_EXCEEDS_100_CHARS \
		"Interfaces file name exceeds 100 characters.\n"
#define ERR_PASSWORD_EXCEEDS_200_CHARS \
		"Password exceeds 200 characters.\n"
		


/*
==================================================================================
referred to sysexits.h as suggested by marc<marcxdv@welz.org.za>

Since there are error return values that have a defined meaning, it
makes sense to use them as they are meant to. The rest of errors will
be defined to have values above:
#define EX__MAX	78	maximum listed value

 Error values not defined here, have the meanings of the external 
 program's return value.

 return value of 101 means operation not defined
 return value of 64 means incorrect number of parameter for operation selected
 return value of 103 means interfaces file name exceeds 100 characters
 return value of 104 means password exceeds 200 characters
 return value of 105 means buffer overflow - this would imply the presence of 
		a BUG
==================================================================================
*/

//enum XBoolean {XTrue, XFalse, XNeutral};

typedef enum {
	opSave,
	opSaveConnect,
	opQueryConnect,
	opDeleteConnect,
	opConnectionConnect, 
	opDisconnectActiveConnection,
	opScan,
	opLoadExisting,
	opScanDetailed,
	
	// This is important to avoid attempting a valid operation on error
	opUndefined
} OP_TYPE;
	
/*
#define opSave				0
#define opSaveConnect			1
#define opQueryConnect			2
#define opDeleteConnect			3
#define opConnectionConnect			4
#define opDisconnectActiveConnection	5
#define opScan				6
#define opLoadExisting			7
*/


int main(int argc, char *argv[])
{
	char *out = 0;
	OP_TYPE switch_item = opUndefined;
	int i;
	
	if (argc > 1)
	{
		// the first parameter must be a digit between 0 and 7
		// check length and converted value.
		if (strlen(argv[1]) == 1)
			switch_item = atoi(argv[1]);
		else {
			printf(ERR_OP_NOT_DEFINED);
			return 101;
		}	
		// atoi return zero if input is not a number
		// At this point we are sure argv[1] contains just one character
		if (switch_item == 0)
		{
			if (argv[1][0] != '0') {
				printf(ERR_OP_NOT_DEFINED);
				return 101;
			}
		}
		
		if (switch_item >= opUndefined)
		{
			printf(ERR_OP_NOT_DEFINED);
			return 101;
		}
	} else
	{
		printf("No parameters supplied.\n");
		return 101;
	}
	
		
	// make sure parameters make it safe to proceed
	int valid = 0;
	if (argc == 2) {
			if ( 
				switch_item == opDisconnectActiveConnection	||
				switch_item == opScan												||
				switch_item == opLoadExisting								||
				switch_item == opScanDetailed
			) valid = 1; // this means number of parameters is correct
			
			if (!valid) {
				printf(ERR_INVALID_NO_OF_PARAMS);
				return 64;
			}			
		}
	else if (argc == 3) {
			if ( 
				switch_item == opQueryConnect				||
				switch_item == opDeleteConnect			||
				switch_item == opConnectionConnect
			) valid = 1; // this means number of parameters is correct
			
			if (!valid) {
				printf(ERR_INVALID_NO_OF_PARAMS);
				return 64; // again incorrect number of parameters
			}
			
			// here, we are checking the length of the ESSID
			// 52^100 permutions should be enough for a file name
			if (strlen(argv[2]) > 100) {
				printf(ERR_INTERFACES_FILE_NAME_EXCEEDS_100_CHARS);
				return 103; // interfaces file name too long
			}
		}
	else if (argc == 4) {
			if ( switch_item == opSave	|| switch_item == opSaveConnect)
				valid = 1; // this means number of parameters is correct
			
			// again incorrect number of parameters
			if (!valid) {
				printf(ERR_INVALID_NO_OF_PARAMS);
				return 64; 
			}
			
			// 52^100 permutions should be enough for a file name
			if (strlen(argv[2]) > 100) {
				printf(ERR_INTERFACES_FILE_NAME_EXCEEDS_100_CHARS);
				return 103; // interfaces file name too long
			}
				
			// maximum password length of 200	
			if (strlen(argv[3]) > 200) {
				printf(ERR_PASSWORD_EXCEEDS_200_CHARS);
				return 104;
			}	
		}


	switch (switch_item) {
		case opSave:
			i = saveFile(argv[2], argv[3]);
			
			//printf(out);
			return i;
			
		case opSaveConnect:
			i = saveFile(argv[2], argv[3]);
			if (i == 0) i = connectionConnect(argv[2]);
			return i;
			
		case opQueryConnect:
			i = queryConnect(argv[2]); 
			return i;
			
		case opDeleteConnect:
			i = deleteConnect(argv[2]);
			return i;
			
		case opConnectionConnect:
			i = connectionConnect(argv[2]);
			return i;
			
		case opDisconnectActiveConnection:
			i = disconnectActiveConnection();
			return i;
			
		case opScan:
			i = scan();
			return i;
			
		case opLoadExisting:
			i = loadExisting();
			return i;
			
		case opScanDetailed:
			i = power_scan(deep);
			return i;
	}
	
	return 101; // operation not defined
}