#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <alloca.h>

#include "paths.h"
#include "file_functions.h"


// As suggested by <rainerweikusat@virginmedia.com>
	int saveFile(char* essid, char* pw) //argv[2], argv[3]
	{
		char *path;
		FILE *fp;
		unsigned p_len, e_len;

		p_len = strlen(IFACES_PATH);
		e_len = strlen(essid);
		path = alloca(p_len + e_len + 2);

		strcpy(path, IFACES_PATH);
		path[p_len] = '/';
		strcpy(path + p_len + 1, essid);

		fp = fopen(path, "w");
		fprintf(fp, IFACE_TMPL, essid, pw);
		fclose(fp);
	
		return 0;
	}
	
	int queryConnect(char* essid) //argv[2]
	{
		char s[50*1024];
		char command[1024];
		
		int result = snprintf(command, 1024, "/bin/cat "IFACES_PATH"/%s | grep -A 1 wpa-ssid", essid);
		if (result >= 1024)
			return 105;
		
		int q = exec(command, s);
		printf(s);
		return q;
	}
	
	// As suggested by marc<marcxdv@welz.org.za>
	int deleteConnect(char* essid) //argv[2]
	{
		char command[1024];
		int result;
		result = snprintf(command, 1024, IFACES_PATH"/%s", essid);
		if(result >= 1024) {
			return 105;  // buffer overflow - software internal error BUG
		}
		return unlink(command);
	}
	
	
	// loads the wifi hots spots for which there is an interfaces file in
	// /etc/network/wifi
	int loadExisting()
	{
		DIR *dir;
		struct dirent *ent;
		
		if ((dir = opendir (IFACES_PATH)) != 0) 
		{
			while ((ent = readdir (dir)) != 0)
			  if (!(strcmp(".", ent->d_name) == 0 || strcmp("..", ent->d_name) == 0))
					printf ("%s\n", ent->d_name);
			
			closedir (dir);
			return 0;
		} 
		else 
		{
			perror ("");
			return EXIT_FAILURE;
		}
	}
