#ifndef FILE_FUNCTIONS_H_
#define FILE_FUNCTIONS_H_


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <alloca.h>

#include "paths.h"



#define IFACE_TMPL \
        "auto lo\n" \
        "iface lo inet loopback\n\n" \
        "iface wlan0 inet dhcp\n" \
        "    wpa-ssid %s\n" \
        "    wpa-psk \"%s\"\n"



// saves a new interfaces file with the ESSID as the filename
// File location is: /etc/network/wifi
int saveFile(char* essid, char* pw);


// reads the ESSIDs from the installed interfaces file in 
// /etc/network/wifi
int queryConnect(char* essid);


// deletes an interfaces file with the name essid from
// /etc/network/wifi
int deleteConnect(char* essid);


#endif /* FILE_FUNCTIONS_H_ */