<?php

namespace App\Controller;

use App\Entity\Task;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\VarDumper\VarDumper;

use Symfony\Component\Form\Forms;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\DateType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TelType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ArrayCollection;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;

use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Routing\Annotation\Route;


use App\Entity\Abonnes;
use App\Entity\Formation;
use App\Entity\Experience;
use App\Entity\Tag;

class FormulaireController extends AbstractController
{
    /**
     * @Route("/formulaire", name="formulaire")
     */

    public function add(Request $request)
    {
    	$abonnes = new Abonnes();

    	$form = $this->createFormBuilder($abonnes)
    		->add('nom', TextType::class)
    		->add('prenom', TextType::class)
    		->add('email', EmailType::class)
    		->add('telephone', TelType::class)
    		->add('adresse', TextType::class)
    		->add('codepostal', NumberType::class)
    		->add('ville', TextType::class)
    		->add('domaine', ChoiceType::class, array(
	            'choices'  => array(
	                'Informatique' => 'Informatique',
	                'Communication' => 'Communication',
	                'Marketing' => 'Marketing',
	             ),
	        ))
	        ->add('tag', CollectionType::class, array(
		        'entry_type'   => TagsType::class,
		        'allow_add'    => true,
		        'allow_delete' => true
		      ))
    		->add('topformation', TextType::class)
    		->add('formation', CollectionType::class, array(
		        'entry_type'   => FormationsType::class,
		        'allow_add'    => true,
		        'allow_delete' => true
		      ))
    		->add('experience', CollectionType::class, array(
		        'entry_type'   => ExperiencesType::class,
		        'allow_add'    => true,
		        'allow_delete' => true
		      ))
    		->add('cv', FileType::class, array(
    			'required' => false
    		))
    		->add('save', SubmitType::class, array('label' => 'envoyer le formulaire'))
            ->getForm();

            $form->handleRequest($request);

		    if ($form->isSubmitted() && $form->isValid()) {
		       
		        $task = $form->getData();
		        $entityManager = $this->getDoctrine()->getManager();
		        $entityManager->persist($task);
		        $entityManager->flush();

		        //return $this->redirectToRoute('formulaire_envoye');

		    }

        return $this->render('formulaire/add.html.twig', array(
            'form' => $form->createView(),
        ));
    }

    public function envoye()
    {
    	return $this->render('formulaire/envoye.html.twig');
    }

}



class TagsType extends AbstractType
	{
	  public function buildForm(FormBuilderInterface $builder, array $options)
	  {
	    $builder
	      ->add('tag', TextType::class);
	  }

	  public function configureOptions(OptionsResolver $resolver)
	  {
	    $resolver->setDefaults(array(
	      'data_class' => 'App\Entity\Tag'
	    ));
	  }
	}

class FormationsType extends AbstractType
	{
	  public function buildForm(FormBuilderInterface $builder, array $options)
	  {
	    $builder
	      ->add('etablissement', TextType::class)
	      ->add('specialisation', TextType::class)
	      ->add('diplome', TextType::class);
	  }

	  public function configureOptions(OptionsResolver $resolver)
	  {
	    $resolver->setDefaults(array(
	      'data_class' => 'App\Entity\Formation'
	    ));
	  }
	}

class ExperiencesType extends AbstractType
	{
	  public function buildForm(FormBuilderInterface $builder, array $options)
	  {
	    $builder
	      ->add('employeur', TextType::class)
	      ->add('poste', TextType::class)
	      ->add('debut', DateType::class, array(
    			'widget' => 'single_text',
    			'html5' => false,
    			// this is actually the default format for single_text
    			'format' => 'dd/mm/yyyy',
    			// adds a class that can be selected in JavaScript
    			'attr' => ['class' => 'js-datepicker']))
	      ->add('fin', DateType::class, array(
    			'widget' => 'single_text',
    			'required' => false,
    			'html5' => false,
    			// this is actually the default format for single_text
    			'format' => 'dd/mm/yyyy',
    			// adds a class that can be selected in JavaScript
    			'attr' => ['class' => 'js-datepicker']))
	      ->add('actuel', CheckboxType::class, array(
    			'required' => false
    		));
	  }

	  public function configureOptions(OptionsResolver $resolver)
	  {
	    $resolver->setDefaults(array(
	      'data_class' => 'App\Entity\Experience'
	    ));
	  }
	}
