% Copyright (C) 2005 Harish Narayanan
% Licensed under the GNU GPL Version 3

% A more sophisticated distance function evaluator. Uses a fast sweeping
% method to solve the Eikonal equation norm(grad(d))=1 on Omega, and 
% d = 0 on Gamma. The resulting field d is a distance function.

% References: Class notes, and details of the implementation from
%
% "A FAST SWEEPING METHOD FOR EIKONAL EQUATIONS"
% HONGKAI ZHAO
% 
% MATHEMATICS OF COMPUTATION
% Volume 74, Number 250, Pages 603627
% S 0025-5718(04)01678-3
% Article electronically published on May 21, 2004

% Initial cleanup
clear all; clc; close all; hold off;
format long;

% We need a large value, so why not use the maximum double precision
% floating point integer?
infinity = bitmax; 

% Dimensions of the mesh
width  = 10;
height = 10;

% Density of the mesh
% Modify this to allow it to be different in the different directions
h = 0.1;

% Number of nodes along each axis
nodex = width/h+1.;
nodey = height/h+1.;
    
% Find the positions of the nodes on the mesh and store it in 'pos'
pos = zeros (nodey,nodex,2);
for i = 1:nodey
    for j = 1:nodex
        pos(i,j,1) = (j-1.)*h;
        pos(i,j,2) = (i-1.)*h;
    end
end

% Initialise the distance field 'u' to some large value at all nodes
u = infinity*ones(nodey,nodex);

% Define known points on theset 'S' we are aiming to capture with this
% algorithm

% Test cases

% % a. Some random points, loosely forming some shape
%S=[0,0; 1,1; 3,4; 7,5; 10,5];

S=[4.,2.; 3.,6.; 5.,8.; 8.,6.5; 7.,2.;]; %EXAMPLE USED
%S=[4,2; 3,8; 5,6; 7,2; 8,6]; %Non convex



% bbox

% % b. The diagonal
% S=[];
% for i = 1:nodex
%    for j = 1:nodey
%        if i==j S=[S', [pos(i,j,1) pos(i,j,2)]']'; end
%     end
% end

% c. A central circle
% S=[];
% for i = 1:nodex
%    for j = 1:nodey
%        distfromcenter = (pos(i,j,1)-width/2.)^2+(pos(i,j,2)-height/2.)^2;
%        if (abs(distfromcenter-5)<=h*sqrt(2)) S=[S', [pos(i,j,1) pos(i,j,2)]']'; 
%        end
%     end
% end

%Determine bounding box of point for a decent initial guess at the level
% set function
bbox = zeros(2,2);
bbox(1,:) = min(S)-h;
bbox(2,:) = max(S)+h;

% Hold all the nodes we've set initially in 'found', so we don't waste time
% calculating these nodes later

found = [];

% Set appropriate values to 'u' from the known points, 'S'
%       a) If x lies on a grid point, u(x) = 0

% Do something less intensive below!
for i=1:nodey
    for j=1:nodex
        for k=1:size(S,1)
            if ((S(k,1)==pos(i,j,1)) & (S(k,2)==pos(i,j,2)))
                found = [found [i,j]'];
                u(i,j)=0.;
            end
        end
    end
end
found=found';

%       b) If x lies close to a grid point, assign interpolated values

%%%% WRITE ME %%%%

% Check if originally defined 'u' looks decent
%u
%contourf(u)

% Perform the Gauss-Seidel iterations

% First pass  -- Lower left to upper right
for i=1:nodey
    for j=1:nodex
        seidel
    end
end

% Second pass -- Lower right to upper left
for i=1:nodey
    for j=nodex:-1:1
        seidel
    end
end

% Third pass  -- Upper right to lower left
for i=nodey:-1:1
    for j=nodex:-1:1
        seidel
    end
end

% Fourth pass -- Upper left to lower right
for i=nodey:-1:1
    for j=1:nodex
        seidel
    end
end

% Fifth pass, to guarantee convergence.
% Arbitrarily chosen to be lower left to upper right
for i=1:nodey
    for j=1:nodex
        seidel
    end
end

% Check the distance function calculator
contourf(u)
hold on
plot(S(:,1)*1/h+1,S(:,2)*1/h+1,'rs','MarkerEdgeColor','k',...
                'MarkerFaceColor','g',...
                'MarkerSize',10)
hold off
pause

# %surfc(pos(:,:,1), pos(:,:,2),u)
# %shading interp
# colormap jet
# %axis equal
# colorbar

# %pause

# % Determine the gradient using the stencil
# %   |
# % --u--
# %   |

# gradu_x     = zeros (nodey,nodex);
# gradu_y     = zeros (nodey,nodex);
# norm_gradu  = zeros (nodey,nodex);

# %[gradu_x, gradu_y] = gradient (u,h,h);


#  for i=2:nodey-1
#      for j=2:nodex-1
#          gradu_y(i,j) = (u(i+1,j)-u(i-1,j))/(2*h);
#          gradu_x(i,j) = (u(i,j+1)-u(i,j-1))/(2*h);
#          norm_gradu(i,j) = sqrt (gradu_x(i,j)^2+gradu_y(i,j)^2);
#      end
#  end

# %contourf(norm_gradu(2:nodey-1,2:nodex-1));

# % surfc(pos(:,:,1), pos(:,:,2),norm_gradu)
# % shading interp
# % colormap jet
# % %axis equal
# % colorbar


# % 

# % Start level set stuff. Use bbox for a rough guess at the initial
# % function

# phi = ones(nodey,nodex);
# for i=1:nodey
#      for j=1:nodex
#          if (pos(i,j,1)>=bbox(1,1)&pos(i,j,1)<=bbox(2,1)...
#                  & pos(i,j,2)>=bbox(1,2)&pos(i,j,2)<=bbox(2,2))
#              phi(i,j)=-1;
#          end
             
#      end
# end



# surf(phi)
# pause
# contour(phi,[0 0],'b');
# pause
# phi = double((phi > 0).*(bwdist(phi < 0)-0.5)...
#            - (phi < 0).*(bwdist(phi > 0)-0.5));
# surf(phi)
# pause
# contour(phi,[0 0],'b');
# pause
# for j=1:10
# %phi = evolve2D(phi,h,h,10*h^2,3000,'ENO3',1,0,0,1,-gradu_x,-gradu_y,1,u);
# phi =  evolve2D(phi,h,h,0.5,800,'ENO3',1,0,0,1,-gradu_x,-gradu_y,1,u);
# phi = reinit_SD(phi, h, h, 0.5, 'WENO', 200);       
# %Second set of calculations use phi above
#               %phi, dx, dy, alpha, iterations, accuracy,
#               %is_signed_distance, normal_evolve, Vn, vector_evolve,
#               %u, v, kappa_evolve, b)

# %surf(phi)
# %pause
# %hold off
# %plot(S(:,1),S(:,2),'rs','MarkerEdgeColor','k',...
#  %               'MarkerFaceColor','g',...
#   %              'MarkerSize',10)
# %axis([1 10 1 10])
# hold on            
# contour(phi,[0 0],'r');
# %hold off
# end
# plot(S(:,1)*1/h+1,S(:,2)*1/h+1,'rs','MarkerEdgeColor','k',...
#                 'MarkerFaceColor','g',...
#                 'MarkerSize',10)