% Copyright (C) 2005 Harish Narayanan
% Licensed under the GNU GPL Version 3

% The Gauss-Seidel loop

% Only carried out if the node hasn't been set initially
if ~(isinfound([i,j],found))
    if ((i>1)*(i<nodey))
        uymin = min(u(i-1,j),u(i+1,j));
    elseif (i==1)
        uymin = u(2,j);
    else
        uymin = u(nodey-1,j);
    end

    if ((j>1)*(j<nodex))
        uxmin = min(u(i,j-1),u(i,j+1));
    elseif (j==1)
        uxmin = u(i,2);
    else
        uxmin = u(i,nodex-1);
    end

    if (abs(uxmin-uymin)>=h)
        ubar = min(uxmin,uymin)+h;
    else
        ubar = (uxmin+uymin+sqrt(2*h^2-(uxmin-uymin)^2))/2;
    end

    u(i,j)=min(u(i,j),ubar);
end %if