#! /usr/bin/env python

import re, smtplib, imaplib, time, sys, datetime

RFC_822_SIZE_RE = re.compile(r'.* RFC822\.SIZE (?P<size>\d+)')

def log_print(msg):
    print ('%s %s' % (datetime.datetime.now(), msg))

def send_file(server, recip, filename):
    f = open(filename, 'rb')
    msg = f.read()
    f.close()

    server = smtplib.SMTP(server)
    server.sendmail('test@test.org', recip, msg)
    server.quit()
    log_print('Sent %d bytes to %s' % (len(msg), recip))

def send_fetch_test(server, user, password, filename):
    M = imaplib.IMAP4(server)
    (stat, data) = M.login(user, password)
    if stat != 'OK':
        raise Exception, ("User '%s' login fail" % user)
    (stat, data) = M.select('INBOX')
    if stat != 'OK':
        raise Exception, 'select fail %s (%s)' % (user, data)
    if data[0] != '0':
        # Some messages exist. Delete all of them
        (stat, data) = M.uid('STORE', '1:*', '+FLAGS.SILENT', '(\\Deleted)')
        if stat != 'OK':
            raise Exception, 'UID STORE FLAGS fail %s (%s)' % (user, data)
        (stat, data) = M.expunge()
        if stat != 'OK':
            raise Exception, 'EXPUNGE fail %s (%s)' % (user, data)
    # No messages in inbox. Send the email now
    # raw_input('Check imap pid now and press enter')
    send_file(server, user, filename)
    # Wait until message is received
    while True:
        (stat, data) = M.uid('fetch', '1:*', '(FLAGS INTERNALDATE RFC822.SIZE)')
        if stat != 'OK':
            raise Exception, 'fetch fail %s (%s)' % (user, data)
        line = data[0]
        if line:
            rfc_size_match = RFC_822_SIZE_RE.match(line)
            if rfc_size_match == None:
                raise Exception, 'RFC822.SIZE not found in response %s (%s)' % (user, line)
            rfc_size = int(rfc_size_match.group('size'))
            if (rfc_size == 0):
                log_print('**** ERROR: Got invalid RFC822.SIZE %d: %s' % (rfc_size, line))
                time.sleep(1)
            else:
                log_print('Got valid RFC822.SIZE %d: %s' % (rfc_size, line))
                break
        else:
            log_print('No messages in INBOX. Waiting...')
            time.sleep(1)
    M.logout()


if __name__ == "__main__":
    print sys.argv
    if len(sys.argv) < 4 or len(sys.argv) > 5:
        print "Usage: %s USER PASSWORD FILE [SERVER]" % (sys.argv[0])
        sys.exit(1)
    user = sys.argv[1]
    password = sys.argv[2]
    file = sys.argv[3]
    if len(sys.argv) == 5:
        server = sys.argv[4]
    else:
        server = 'localhost'


    send_fetch_test(server, user, password, file)
