
/*
The test application code. For most of the settings, the application needs to be recompiled.
*/
		
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "ffp.h"
// implementation of a matrix inversion operation, courtesy of Jacques
// Leroy who contributed the code to Mesa
#include "matrix.h"
#define GL_GLEXT_PROTOTYPES

//#include "GL/GL_ARB_vertex_program.h"
#include "GL/glut.h"
#include <GL/gl.h>


extern int hw_vertprog_on;

//void invert_matrix_general(GLfloat const* m, GLfloat* out);

GLboolean invert_matrix_general( GLmatrix *mat );

static float Xrot = 0.0, Yrot = 0.0, Zrot = 0.0;
		
//GLfloat angle = 0;                                         // rotation angle
GLboolean lighting = GL_TRUE; //GL_FALSE;
GLuint colorMode = GL_SINGLE_COLOR;
GLboolean twoSidedMode = GL_FALSE;
GLboolean localViewer = GL_FALSE; //GL_TRUE; //GL_FALSE;
GLboolean normalize = GL_TRUE; //GL_FALSE;
GLboolean rescalingon = GL_FALSE; //GL_TRUE; //GL_FALSE; ////////GL_TRUE;
GLfloat zoom = 1.0;                                        // zoom factor
char * progarb;


/*
  Helper function that normalizes either light positions
  or spot direction and entering them into parameters
  available to the vertex program.
  f: light position of spot direction
  lightIndex: light source number
  spot: whether f is light position or spot direction
 */
static void normalizeLight(float * f, int lightIndex, GLboolean spot) {
   if (spot) {
        PFNGLPROGRAMLOCALPARAMETER4FVARBPROC glProgramLocalParameter4fvARB;
        int i;
        float tall = 0;
        float h[4];
        for(i=0; i < 3; i++) {
           tall += f[i]*f[i];
        }
        tall = 1/(sqrt(tall));
        for(i=0; i < 3; i++) {
           h[i] = f[i]*tall;
        }
        h[3] = 0.0;
        glProgramLocalParameter4fvARB = (PFNGLPROGRAMLOCALPARAMETER4FVARBPROC) wglGetProcAddress("glProgramLocalParameter4fvARB");
        (*glProgramLocalParameter4fvARB) (GL_VERTEX_PROGRAM_ARB, lightIndex + 16, h);
   } else if ( f[3] == 0 ) { // Infinite light
        PFNGLPROGRAMLOCALPARAMETER4FVARBPROC glProgramLocalParameter4fvARB;
        int i;
        float tall = 0;
        float g[4];
        for(i=0; i < 4; i++) {
           tall += f[i]*f[i];
        }
        tall = 1/(sqrt(tall));
        for(i=0; i < 4; i++) {
         g[i] = f[i]*tall;
       }
      glProgramLocalParameter4fvARB = (PFNGLPROGRAMLOCALPARAMETER4FVARBPROC) wglGetProcAddress("glProgramLocalParameter4fvARB");
      (*glProgramLocalParameter4fvARB) (GL_VERTEX_PROGRAM_ARB, lightIndex, g);
	printf("light normal %f, %f, %f, %f\n", g[0], g[1], g[2], g[3]);
   }
}

static void rescale()
{
   PFNGLPROGRAMLOCALPARAMETER4FVARBPROC glProgramLocalParameter4fvARB;
   GLfloat scale[4];
	GLmatrix *foo;
	
   GLfloat f[16], *g/*[16]*/;
   glGetFloatv(GL_MODELVIEW_MATRIX, f);
   
   foo=malloc(sizeof(GLmatrix));
   foo->m=f;
   foo->inv=malloc(16*sizeof(float));
   invert_matrix_general(foo/*f, g*/);
   
   g=foo->inv;
		   
   scale[0] = 1/sqrt(g[2]*g[2]+g[6]*g[6]+g[10]*g[10]);
   scale[1] = scale[0];
   scale[2] = scale[0];
   scale[3] = scale[0];
   
   //scale[0]=scale[1]=scale[2]=scale[3]=1.0;
   //printf("rescaling...\n");
   glProgramLocalParameter4fvARB = (PFNGLPROGRAMLOCALPARAMETER4FVARBPROC) wglGetProcAddress("glProgramLocalParameter4fvARB");
   (*glProgramLocalParameter4fvARB) (GL_VERTEX_PROGRAM_ARB, 40, scale);
   //printf("\n\nscale %f\n", scale[0]);
}

/*
  Function that initializes lights and other variables.
*/

void init(void)
{
	float positions[3][4]={ {-0.5, -0.5, -1.0, +0.0},
				{+1.0, +1.0, -1.0, +1.0},
				{-0.5,  1.0, -1.0, +1.0} };
	int index;
	
	// Lightmodel parameter
	glLightModelf(GL_LIGHT_MODEL_LOCAL_VIEWER, localViewer);
	glLightModelf(GL_LIGHT_MODEL_TWO_SIDE, twoSidedMode);
	glLightModelf(GL_LIGHT_MODEL_COLOR_CONTROL, colorMode);
	
	for(index=0; index < 3; index++){
		glLightfv(GL_LIGHT0+index, GL_POSITION, positions[index]);
		normalizeLight(positions[index], index, GL_FALSE);
	}
	
  // Lights
  if (normalize) {
     { float f[4] = {+0.0, +1.0, +1.0, +0.0};
     glLightfv(GL_LIGHT0, GL_DIFFUSE, f); }
     { float f[4] = {+1.0, +1.0, +1.0, +0.0};
     glLightfv(GL_LIGHT0, GL_SPECULAR, f); }

     { float f[4] = {+1.0, +0.0, +0.0, +0.0};
     glLightfv(GL_LIGHT1, GL_DIFFUSE, f); }
     { float f[4] = {+1.0, +0.0, +0.0, +0.0};
     glLightfv(GL_LIGHT1, GL_SPECULAR, f); }

     { float f[4] = {+0.0, +1.0, +0.0, +0.0};
     glLightfv(GL_LIGHT2, GL_DIFFUSE, f); }
     { float f[4] = {+0.0, +1.0, +0.0, +0.0};
     glLightfv(GL_LIGHT2, GL_SPECULAR, f); }
     { float f[1] = {20};
     glLightfv(GL_LIGHT2, GL_SPOT_CUTOFF, f); }
     { float f[3] = {0.5, -1.0, 1.0};
       glLightfv(GL_LIGHT2, GL_SPOT_DIRECTION, f);
       normalizeLight(f, 2, GL_TRUE);  }
  } else {
     { /*float f[4] = {-0.5, -0.5, 0.4, +0.0};
     glLightfv(GL_LIGHT0, GL_POSITION, f);*/
     /*normalizeLight(f, 0, GL_FALSE);*/ }
     { float f[4] = {+0.0, +1.0, +1.0, +0.0};
     glLightfv(GL_LIGHT0, GL_DIFFUSE, f); }
     { float f[4] = {+1.0, +1.0, +1.0, +0.0};
     glLightfv(GL_LIGHT0, GL_SPECULAR, f); }

     { /*float f[4] = {+0.5, +0.5, 1.0, +1.0};
     glLightfv(GL_LIGHT1, GL_POSITION, f);*/
     /*normalizeLight(f, 1, GL_FALSE);*/ }
     { float f[4] = {+1.0, +1.0, +0.0, +0.0};
     glLightfv(GL_LIGHT1, GL_DIFFUSE, f); }
     { float f[4] = {+1.0, +1.0, +1.0, +0.0};
     glLightfv(GL_LIGHT1, GL_SPECULAR, f); }

     { /*float f[4] = {-0.5, -0.5, 1.0, +1.0};
     glLightfv(GL_LIGHT2, GL_POSITION, f);*/
     /*normalizeLight(f, 2, GL_FALSE);*/ }
     { float f[4] = {+1.0, +0.0, +0.0, +0.0};
     glLightfv(GL_LIGHT2, GL_DIFFUSE, f); }
     { float f[4] = {+1.0, +0.0, +0.0, +0.0};
     glLightfv(GL_LIGHT2, GL_SPECULAR, f); }
     { float f[1] = {22};
//     glLightfv(GL_LIGHT0, GL_SPOT_CUTOFF, f); }
     glLightfv(GL_LIGHT2, GL_SPOT_CUTOFF, f); }
     { float f[3] = {0.5, 0.5, -1.0};
//     glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, f);
     glLightfv(GL_LIGHT2, GL_SPOT_DIRECTION, f);
     normalizeLight(f, 0, GL_TRUE);
     }
  }

  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHT1);
  glEnable(GL_LIGHT2);

  if (normalize)
     glEnable(GL_NORMALIZE);
  else
     glDisable(GL_NORMALIZE);

  if (rescalingon)
     glEnable(GL_RESCALE_NORMAL);
  else
     glDisable(GL_RESCALE_NORMAL);

  if (twoSidedMode)
     glEnable(GL_VERTEX_PROGRAM_TWO_SIDE_ARB);
  else
     glDisable(GL_VERTEX_PROGRAM_TWO_SIDE_ARB);

}
#define VP

void program(){
GLuint prognum;
#ifdef VP	   
   {
      //if (glBindProgramARB) {
         int errorpos;
         const GLubyte * str;
	 glGenProgramsARB(1, &prognum);
	 glBindProgramARB(GL_VERTEX_PROGRAM_ARB, prognum);
	 //(*glBindProgramARB)(GL_VERTEX_PROGRAM_ARB, 1);
         init();
   if(normalize) printf("normalize1\n");
         constructVertexProgram();
//         progarb = make_vertex_program();
         progarb = getVertexProgram();
	 printf("programming...\n");
	 glProgramStringARB(GL_VERTEX_PROGRAM_ARB,
                               GL_PROGRAM_FORMAT_ASCII_ARB,
                               strlen(progarb), (const GLubyte *) progarb);
	 printf("done\n");
         glGetIntegerv(GL_PROGRAM_ERROR_POSITION_ARB, &errorpos);
	 printf("errorpos=%d\n", errorpos);
	 printf("error at %s\n", progarb+errorpos);
	 
         str = glGetString(GL_PROGRAM_ERROR_STRING_ARB);
         printf("string %s\n", str);
         //printf("\nError %i and ep %f and string %s\n", glGetError(), ep[0], (char*)str);
         printf("program:\n <%s>\n", progarb);
      //}
      //cleanResources();
   }glEnable(GL_VERTEX_PROGRAM_ARB);
#endif   
}

#define STEP 0.05
#define MAX(a, b) ((a)>(b)?(a):(b))
/*
  The display function that creates all the geometry
  that are to be rendered.
*/
void display(void)
{
	GLfloat position[] = {0, 0, 0, 0};
	float f, g;
	int i;
	//program();
	
	PFNGLSECONDARYCOLOR3FEXTPROC glSecondaryColor3fEXT;
	glSecondaryColor3fEXT = (PFNGLSECONDARYCOLOR3FEXTPROC) wglGetProcAddress("glSecondaryColor3fEXT");
	glClearColor(0.2, 0.2, 0.2, 1.0);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
   
	for(i=0; i < 8; i++){
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glPointSize(10);
		glGetLightfv(GL_LIGHT0+i, GL_POSITION, position);
		glColor3f(1.0, 1.0, 1.0);
		glBegin(GL_POINTS);
		glVertex3f(position[0], position[1], position[2]);
		glEnd();
	}
		   
	glDepthFunc(GL_LESS);
	glDepthMask(GL_TRUE);
	glEnable(GL_DEPTH_TEST);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	//glRotatef(35, 0, 1, 0);
	//glRotatef(angle, 1, 0, 0);
	glRotatef(Xrot, 1, 0, 0);
	glRotatef(Yrot, 0, 1, 0);
	glRotatef(Zrot, 0, 0, 1);
	glScalef(zoom, zoom, zoom);
	//glTranslatef(0, 0, 1);

	if (rescalingon)
		rescale();
	
	glColor3f(0.5, 0.5, 0.5);
	//(*glSecondaryColor3fEXT)(0, 1, 0);
	//glSecondaryColor3f(0, 1, 0);
	if (normalize) {
		printf("normalized\n");
		//glutSolidTorus(0.5, 6.0, 10, 20);
		//glutSolidTeapot(0.6);
		glEnable(GL_NORMALIZE);
	} else {
		GLfloat f, g;
		glDisable(GL_NORMALIZE);
	}
	//glutSolidTorus(0.2, 0.7, 40, 40);
	glutSolidTeapot(0.8);
	/*
	glBegin(GL_POINTS);
	glVertex3f(0.0, 0.0, 0.0);
	glEnd();
      	*/
#if 0
      for (f = -0.9; f < (+0.91 - STEP); f += STEP) {
         glBegin(GL_QUAD_STRIP);
         for (g = -0.9; g < +0.91; g += STEP) {
		glColor3f(0.4, 0.4, 0.4);
            glVertex2f(f,g);
            glVertex2f(f+STEP,g);
         }
         glEnd();
      }
#endif
	
	glutSwapBuffers();
}

/*
  Function that handles reshaping of the application window.
*/

void reshape(int w, int h)
{
    glViewport(0, 0, w, h);
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
}

/*
  Function that handles keyboard input.
*/

void keyboard(unsigned char key, int x, int y)
{
	switch (key) {
	/*
	case 'a':
		glEnable(GL_VERTEX_PROGRAM_ARB);
		if(rescalingon)
			glDisable(GL_RESCALE_NORMAL);
	break;
	case 'n':
		glDisable(GL_VERTEX_PROGRAM_ARB);
		if(rescalingon)
		glEnable(GL_RESCALE_NORMAL);
	break;
	*/
	case '1':
		hw_vertprog_on=1;
		glEnable(GL_VERTEX_PROGRAM_ARB);
		printf("hw vertex program enabled\n");
		if(rescalingon)
			glDisable(GL_RESCALE_NORMAL);
	break;
	case '2':
		hw_vertprog_on=0;
		glEnable(GL_VERTEX_PROGRAM_ARB);
		printf("software vertex program enabled\n");
		if(rescalingon)
			glDisable(GL_RESCALE_NORMAL);
	break;
	case '3':
		glDisable(GL_VERTEX_PROGRAM_ARB);
		printf("vertex program disabled\n");
		if(rescalingon)
			glEnable(GL_RESCALE_NORMAL);
	break;
	
    case 'Z':
       zoom *= 1.05;
       break;
    case 'z':
       zoom /= 1.05;
       break;
      
    case 'q': exit(0);
    }
    glutPostRedisplay();
}

static void SpecialKey( int key, int x, int y )
{
   const GLfloat step = 3.0;
   (void) x;
   (void) y;
   switch (key) {
      case GLUT_KEY_UP:
         Xrot -= step;
         break;
      case GLUT_KEY_DOWN:
         Xrot += step;
         break;
      case GLUT_KEY_LEFT:
         Yrot -= step;
         break;
      case GLUT_KEY_RIGHT:
         Yrot += step;
         break;
   }
	/*printf("scale %f %f %f %f\n", scale[0], scale[1], scale[2], scale[3]);
	glProgramLocalParameter4fvARB(GL_VERTEX_PROGRAM_ARB, 40, scale);*/
	glutPostRedisplay();
}

void mouse(int button, int state, int x, int y)
{
	GLfloat position[] = {0, 0, 0, 0};
	
	/*glGetLightfv(GL_LIGHT0, GL_POSITION, position);
   
	if (state == GLUT_DOWN){
		position[0]=(x-200)/100.0;
		position[1]=-(y-200)/100.0;
		//position[0]=x/100.0;
	}else if (state == GLUT_UP)
		;
	
	glLightfv(GL_LIGHT0, GL_POSITION, position);*/
	glutPostRedisplay();
}

void trackMotion(int x, int y)
{
  glutPostRedisplay();
}


/*
  Main function. Initializes OpenGL and sets the settings
  that are to tested through init.

  Calls constructVertexProgram() and then getVertexProgram().
  Program is bound and loaded.
*/
int main(int argc, char** argv)
{
   glutInit(&argc, argv);
   glutInitDisplayMode (GLUT_DOUBLE | GLUT_RGB | GLUT_ALPHA | GLUT_DEPTH /*| GLUT_STENCIL*/);
   glutInitWindowSize (400, 400);
   glutCreateWindow (argv[0]);
         init();
	 program();
   	//normalize=0;
	glutReshapeFunc(reshape);
	glutDisplayFunc(display);
	glutKeyboardFunc(keyboard);
	glutSpecialFunc( SpecialKey );
	glutMouseFunc(mouse);
	glutMotionFunc(trackMotion);
   glutIdleFunc(NULL);

   glutMainLoop();

   return 0;
}
