/* float.h for target h8300-elf with optional IEEE 32 bit double format: based float-sh.h */
#ifndef _FLOAT_H_
#define _FLOAT_H_
#include "config/h8300/h8300.h"

/* Produced by enquire version 4.3, CWI, Amsterdam */

   /* Radix of exponent representation */
#undef FLT_RADIX
#define FLT_RADIX 2
   /* Number of base-FLT_RADIX digits in the significand of a float */
#undef FLT_MANT_DIG
#define FLT_MANT_DIG 24
   /* Number of decimal digits of precision in a float */
#undef FLT_DIG
#define FLT_DIG 6
   /* Addition rounds to 0: zero, 1: nearest, 2: +inf, 3: -inf, -1: unknown */
#undef FLT_ROUNDS
#define FLT_ROUNDS 1
   /* Difference between 1.0 and the minimum float greater than 1.0 */
#undef FLT_EPSILON
#define FLT_EPSILON 1.19209290e-07F
   /* Minimum int x such that FLT_RADIX**(x-1) is a normalised float */
#undef FLT_MIN_EXP
#define FLT_MIN_EXP (-125)
   /* Minimum normalised float */
#undef FLT_MIN
#define FLT_MIN 1.17549435e-38F
   /* Minimum int x such that 10**x is a normalised float */
#undef FLT_MIN_10_EXP
#define FLT_MIN_10_EXP (-37)
   /* Maximum int x such that FLT_RADIX**(x-1) is a representable float */
#undef FLT_MAX_EXP
#define FLT_MAX_EXP 128
   /* Maximum float */
#undef FLT_MAX
#define FLT_MAX 3.40282347e+38F
   /* Maximum int x such that 10**x is a representable float */
#undef FLT_MAX_10_EXP
#define FLT_MAX_10_EXP 38

   /* Number of base-FLT_RADIX digits in the significand of a double */
#undef DBL_MANT_DIG
#define DBL_MANT_DIG (DOUBLE_TYPE_SIZE == 64?53:24)
   /* Number of decimal digits of precision in a double */
#undef DBL_DIG
#define DBL_DIG (DOUBLE_TYPE_SIZE == 64?15:6)
   /* Difference between 1.0 and the minimum double greater than 1.0 */
#undef DBL_EPSILON
#define DBL_EPSILON (DOUBLE_TYPE_SIZE == 64?2.2204460492503131e-16:1.19209290e-07F)
   /* Minimum int x such that FLT_RADIX**(x-1) is a normalised double */
#undef DBL_MIN_EXP
#define DBL_MIN_EXP (DOUBLE_TYPE_SIZE == 64?(-1021):(-125))
   /* Minimum normalised double */
#undef DBL_MIN
#define DBL_MIN (DOUBLE_TYPE_SIZE == 64?2.2250738585072014e-308:1.17549435e-38F)
   /* Minimum int x such that 10**x is a normalised double */
#undef DBL_MIN_10_EXP
#define DBL_MIN_10_EXP (DOUBLE_TYPE_SIZE == 64?(-307):(-37))
   /* Maximum int x such that FLT_RADIX**(x-1) is a representable double */
#undef DBL_MAX_EXP
#define DBL_MAX_EXP (DOUBLE_TYPE_SIZE == 64?1024:128)
   /* Maximum double */
#undef DBL_MAX
#define DBL_MAX (DOUBLE_TYPE_SIZE == 64?1.7976931348623157e+308:3.40282347e+38F)
   /* Maximum int x such that 10**x is a representable double */
#undef DBL_MAX_10_EXP
#define DBL_MAX_10_EXP (DOUBLE_TYPE_SIZE == 64?308:38)

/* Because -m3e and -m4-single-only have 32-bit doubles, we append L
   to the doubles below, so that they're not truncated.  */

   /* Number of base-FLT_RADIX digits in the significand of a long double */
#undef LDBL_MANT_DIG
#define LDBL_MANT_DIG (DOUBLE_TYPE_SIZE == 64?53:24)
   /* Number of decimal digits of precision in a long double */
#undef LDBL_DIG
#define LDBL_DIG (DOUBLE_TYPE_SIZE == 64?15:6)
   /* Difference between 1.0 and the minimum long double greater than 1.0 */
#undef LDBL_EPSILON
#define LDBL_EPSILON (DOUBLE_TYPE_SIZE == 64?2.2204460492503131e-16L:1.19209290e-07F)
   /* Minimum int x such that FLT_RADIX**(x-1) is a normalised long double */
#undef LDBL_MIN_EXP
#define LDBL_MIN_EXP (DOUBLE_TYPE_SIZE == 64?(-1021):(-125))
   /* Minimum normalised long double */
#undef LDBL_MIN
#define LDBL_MIN (DOUBLE_TYPE_SIZE == 64?2.2250738585072014e-308L:1.17549435e-38F)
   /* Minimum int x such that 10**x is a normalised long double */
#undef LDBL_MIN_10_EXP
#define LDBL_MIN_10_EXP (DOUBLE_TYPE_SIZE == 64?(-307):(-37))
   /* Maximum int x such that FLT_RADIX**(x-1) is a representable long double */
#undef LDBL_MAX_EXP
#define LDBL_MAX_EXP (DOUBLE_TYPE_SIZE == 64?1024:128)
   /* Maximum long double */
#undef LDBL_MAX
#define LDBL_MAX (DOUBLE_TYPE_SIZE == 64?1.7976931348623157e+308L:3.40282347e+38F)
   /* Maximum int x such that 10**x is a representable long double */
#undef LDBL_MAX_10_EXP
#define LDBL_MAX_10_EXP (DOUBLE_TYPE_SIZE == 64?308:38)

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
   /* The floating-point expression evaluation method.
        -1  indeterminate
         0  evaluate all operations and constants just to the range and
            precision of the type
         1  evaluate operations and constants of type float and double
            to the range and precision of the double type, evaluate
            long double operations and constants to the range and
            precision of the long double type
         2  evaluate all operations and constants to the range and
            precision of the long double type
   */
# undef FLT_EVAL_METHOD
# define FLT_EVAL_METHOD	0

   /* Number of decimal digits to enable rounding to the given number of
      decimal digits without loss of precision.
         if FLT_RADIX == 10^n:  #mantissa * log10 (FLT_RADIX)
         else                :  ceil (1 + #mantissa * log10 (FLT_RADIX))
      where #mantissa is the number of bits in the mantissa of the widest
      supported floating-point type.
   */
# undef DECIMAL_DIG
# define DECIMAL_DIG	17

#endif	/* C99 */

#endif /*  _FLOAT_H_ */
