"""Measures of defeat strength.

A defeat strength function f(x, y) returns the defeat strength of X over Y
if X has x pairwise votes over Y and Y has y pairwise votes over X.  If X
is the pairwise winner, the defeat strength is positive; if y is the
pairwise winner, the defeat strength is negative.
"""

from __future__ import division

def copeland(x, y):
   """
   Return +1 for any victory, -1 for any defeat, and 0 for a tie.
   """
   return cmp(x, y)


def margin(x, y):
   """
   Return the absolute margin of victory of x over y.
   """
   return x - y
   

def relative_margin(x, y):
   """
   Return the relative margin (margin/votes) of x over y.
   """
   return (x - y) / (x + y)
   

def winning_votes(x, y):
   """
   The defeat strength is the number of votes for the winning candidate.
   If there is a tie, the defeat strength is zero.
   """
   if x == y:
      return 0
   elif x < y:
      return -y
   else:
      return x
