#!/usr/bin/env python

"""STV-CLE Vote Calculator

Compute STV-CLE results, using pSTV .blt files as input.
"""

import ballot
import gmpy
import stv_cle
import sys

def parse_blt(input_file):
   """
   Parses a pSTV .blt file.
   Assumes there are no withdrawn candidates.
   Returns the tuple (# of seats, BallotSet)
   """
   num_candidates, num_seats = map(int, input_file.readline().split())
   ballots = []
   while True:
      b = map(int, input_file.readline().split())
      if b == [0]:
         break
      else:
         ballots.append(b)
   candidates = [input_file.readline().strip() for i in xrange(num_candidates)]
   parsed_ballots = []
   for b in ballots:
      weight = gmpy.mpq(b[0])
      ranking = [[candidates[i-1]] for i in b[1:-1]]
      parsed_ballots.append(ballot.RankedBallot(ranking, weight))
   return num_seats, ballot.BallotSet(parsed_ballots)


def _main(argv=sys.argv):
   for blt_filename in argv[1:]:
      print '************ %s ************' % blt_filename
      num_seats, ballots = parse_blt(open(blt_filename))
      winners = stv_cle.stvcle_winners(ballots, num_seats)
      print '*** WINNERS ***'
      for winner in sorted(winners):
         print winner
      print
      print

if __name__ == '__main__':
   _main()

