/***
    Copyright (C) 2013 Template Developers

    This program or library is free software; you can redistribute it
    and/or modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 3 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General
    Public License along with this library; if not, write to the
    Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301 USA.
***/

/**
 * Main class of the application.
 */
public class Template : Gtk.Window {

    public Template () {
        this.title = "Template";
        this.window_position = Gtk.WindowPosition.CENTER;
        this.destroy.connect (Gtk.main_quit);
        set_default_size (500, 300);

        var hbox = new Gtk.Box (Gtk.Orientation.HORIZONTAL, 5);
        hbox.homogeneous = true;
        add (hbox);

        // Welcome widget
        var welcome = new Granite.Widgets.Welcome ("Granite's Welcome Screen",
                                                    "This Is Granite's Welcome Widget.");

        hbox.add (welcome);
    }

    public static int main (string[] args) {
        Gtk.init (ref args);

        var window = new Template ();
        window.show_all ();

        Gtk.main ();
        return 0;
    }

    /*internal void translations () {
        var description = N_("Stylish IRC Client");
        var generic = N_("IRC Client");
    }*/
}


