#include <iostream>
/*
	dlopen c++ procedure more or less inspired from  http://www.tldp.org/HOWTO/C++-dlopen/intro.html
*/

#include <emscripten.h>
#include <dlfcn.h>
#include "..\side\side.h"





int main(int argc, char* argv[])
{
	void *side_lib;
	char *error;
	create_t create_side;
	destroy_t destroy_side;

	emscripten_log(EM_LOG_CONSOLE,"---------------------------------------Init------------------------------");
	
	/* dll opening */
	side_lib = dlopen("side.js",RTLD_NOW);
	if(!side_lib) {
		emscripten_log(EM_LOG_CONSOLE,dlerror());
		return 1;
	}

	dlerror(); // reset errors
	create_side = (create_t)dlsym(side_lib, "create");
	if( (error = dlerror()) != NULL) {
		emscripten_log(EM_LOG_CONSOLE,error);
		dlclose(side_lib);
		return 2;
	}

	dlerror();
	destroy_side = (destroy_t)dlsym(side_lib, "destroy");
	if( (error = dlerror()) != NULL) { 
		emscripten_log(EM_LOG_CONSOLE,error);
		dlclose(side_lib);
		return 2;
	}

	emscripten_log(EM_LOG_CONSOLE,"---------------------------------------Test------------------------------");
	Side *myside = create_side();
	
	myside->hello();

	destroy_side(myside);
	
	return 0;
}

