
#ifndef E_FD_MENU_INCLUDED
#define E_FD_MENU_INCLUDED

#include "EXML.h"

#define E_FD_RULE_INCLUDE 0x0100
#define E_FD_RULE_EXCLUDE 0x0200
#define E_FD_RULE_TAG_MASK 0x0F00

#define E_FD_RULE_ALL	0x01
#define E_FD_RULE_CATEGORY	0x02
#define E_FD_RULE_FILE	0x04
#define E_FD_RULE_TYPE_MASK 0x0F

#define E_FD_RULE_AND 0x10
#define E_FD_RULE_OR 0x20
#define E_FD_RULE_NOT 0x40
#define E_FD_RULE_ACT_MASK 0xF0

typedef struct _E_FD_Menu E_FD_Menu;
typedef struct _E_FD_Rules E_FD_Rules;
typedef struct _E_FD_XML_Tag E_FD_XML_Tag;
typedef struct _E_D_Entry	E_D_Entry;
typedef struct _E_D_Item E_D_Item;

typedef void*(*tag_callback)(EXML*, void*);

#define E_TAG_CB(func) ((tag_callback)func)

struct _E_FD_Rules
{
	int type;

	Evas_List *children;
	/* Data: category or filename */
	Evas_List *data;
};

struct _E_FD_Menu
{
	char *name;
	char *directory;

	/* icon path */
	char *icon;

	/* These two are lists of char* (filenames) */
	Evas_List *app_dirs;
	Evas_List *dir_dirs;

	/* These two are lists of E_FD_Rules */
	Evas_List* rules;
	
	/* submenu list of E_FD_Menu */
	Evas_List* submenus;

	/* item list for E_FD_Menu */
	Evas_List*	items;
	int			items_loaded;
};

struct _E_FD_XML_Tag
{
	char*		tag;
	tag_callback	call;
};

struct _E_D_Entry
{
	char *filename;
	char *dirname;

	Evas_Hash *values;

	E_D_Item *mi;
};

struct _E_D_Item
{
	char *name;
	char *icon;

	char *app;
	
	E_D_Entry *d_entry;
};

E_Menu_Item* e_free_desktop_menu_new(E_Menu *rmn, E_Menu** this);

#endif //!E_FD_MENU_INCLUDED
