/**
 * Simple Ecore program that test evas_object_image_native_surface_set() function
 *
 * You must have Evas compiled with the gl_x11 engine.
 */
#include <Ecore_Evas.h>
#include <Ecore.h>
#include <Evas_Engine_GL_X11.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <GL/glx.h>
#include <GL/gl.h>

#define WIDTH (512)
#define HEIGHT (512)

static void create_texture();

static Ecore_Evas  *ee;
static Display *display;
static int screen;
static GLXContext context;
static GLuint texture;
static unsigned int *data;


void key_down(void *data, Evas *e, Evas_Object *obj, void *event_info)
{
    Evas_Event_Key_Down *ev;
    ev = (Evas_Event_Key_Down *)event_info;

    ecore_main_loop_quit();
}


int main(void)
{
   Evas *canvas;
   Evas_Object *img;
   Evas_Native_Surface ns;

   ecore_init();
   ecore_evas_init();

   ee = ecore_evas_gl_x11_new(NULL, 0, 0, 0, WIDTH, HEIGHT);
   ecore_evas_title_set(ee, "Ecore_Evas Template");
   ecore_evas_borderless_set(ee, 0);
   ecore_evas_show(ee);

   canvas = ecore_evas_get(ee);

   // Create Texture
   create_texture(canvas);

   ns.type = EVAS_NATIVE_SURFACE_OPENGL;
   ns.version = EVAS_NATIVE_SURFACE_VERSION;
   ns.data.opengl.texture_id = texture;
   ns.data.opengl.framebuffer_id = 0;
   ns.data.opengl.internal_format = GL_RGBA;
   ns.data.opengl.format = GL_RGBA;
   ns.data.opengl.x = 0;
   ns.data.opengl.y = 0;
   ns.data.opengl.w = 256;
   ns.data.opengl.h = 256;

   // Add image Object
   img = evas_object_image_add(canvas);
   evas_object_image_fill_set(img, 0, 0, 256, 256);
   evas_object_move(img, 128, 128);
   evas_object_image_load_size_set(img, 256, 256);
   evas_object_resize(img, 256, 256);
   evas_object_image_size_set(img, 256, 256);
   //evas_object_image_data_set(img, (void*)data);
   evas_object_image_native_surface_set(img, &ns);
   evas_object_show(img);

   evas_object_focus_set(img, 1);
   evas_object_event_callback_add(img, EVAS_CALLBACK_KEY_DOWN, key_down, NULL);

   ecore_main_loop_begin();

   ecore_evas_shutdown();
   ecore_shutdown();

   return 0;
}

static void create_texture(Evas *canvas)
{
   Evas_Engine_Info_GL_X11 *einfo;
   int attrib[] = { GLX_RGBA,
        GLX_RED_SIZE, 1,
        GLX_GREEN_SIZE, 1,
        GLX_BLUE_SIZE, 1,
        None };
   XVisualInfo *visinfo;
   GLXContext share_ctx;
   int i,j, w, h;

   display = XOpenDisplay(NULL);
   if (!display) {
        printf("Error: couldn't open display\n");
        exit(1);
   }
   screen = DefaultScreen(display);

   w = 256;
   h = 256;

   data = malloc(w*h*sizeof(unsigned int));

   for (j = 0; j < h; j++)
      for (i=0; i< w; i++)
         data[j*w+i] = j*w+i; 

   einfo = (Evas_Engine_Info_GL_X11 *)evas_engine_info_get(canvas);
   if (!einfo)
     {
        printf("ERROR: could not get evas engine info!\n");
        exit(1);
     }

   share_ctx = glXGetCurrentContext();
   visinfo   = glXChooseVisual(display, 0, attrib);         
   context   = glXCreateContext(display, visinfo, share_ctx, 1);

   glXMakeCurrent( display, einfo->info.drawable, context);

   // allocate a texture nameecore_evas_shutdown();
   glGenTextures( 1, &texture );

   // select our current texture
   glBindTexture(GL_TEXTURE_2D, texture);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
   glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);
   glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);
   glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, w, h, 0, GL_RGBA, GL_UNSIGNED_BYTE, data);

   glXMakeCurrent( display, None, NULL);
}

// Free created stuff
void delete_texture()
{
   glDeleteTextures(1, &texture);
   glXDestroyContext(display, context);
   free(data);
}

/* vim:set ts=8 sw=3 sts=3 expandtab cino=>5n-2f0^-2{2(0W1st0 :*/
