# tc-xml2h converter
This tool can be used to convert a terminal definition file, exported from TwinCAT, to a C headerfile for usage with the Etherlab API.

# Usage
Multiple XML definition files can be passed to the tool. After running, a file "ethercat_config.h" is created in the current directory.

## Generating header file
	./tc-xml2h.py <terminal1.xml> <terminal2.xml> <...>

## Including the header file
*Example (Line: 23)*

	#include "ethercat_config.h"

## Defining slave position
Etherlab needs to know which position the terminal is on. Position is index-style (beginning with 0)   
*Example: 5th slave after the 0th ethercat coupler (Line 45)*

	#define ProfiNetPos 0, 4

## Registering offsets for I/O PDOs
In order to read an write Inputs and Outputs, you have to configure offset variables, which are used with `EC_READ_XX` and `EC_WRITE_XX`.   
*Example: Configuring "Input Data Submodule 1" and "Output Data Submodule 1" (Line: 69-77)*

	static unsigned int off_out_master;
	static unsigned int off_in_master;

	// define your offsets for input and output pdos!
	const static ec_pdo_entry_reg_t domain1_regs[] = {
		{ProfiNetPos, Terminal_1_EL6631, 0x7001, 1, &off_out_master},
		{ProfiNetPos, Terminal_1_EL6631, 0x6001, 1, &off_in_master},
		{}
	};
	
## Download SDOs (CoE initialisation commands) to terminal
For each SDO config in the Headerfile (section "SDO configuration") a `ecrt_slave_config_complete_sdo(...)` call is required in the main function before activating the master.   
*Example for EL_6631 SDOs (Line: 328-337):*

	if (!(sc = ecrt_master_slave_config(master, ProfiNetPos, Terminal_1_EL6631))) {
        fprintf(stderr, "Failed to get slave configuration.\n");
        return -1;
    }

	ecrt_slave_config_complete_sdo(sc, 0xf800, sdo_config_1_0xf800, sizeof(sdo_config_1_0xf800)); 
    ecrt_slave_config_complete_sdo(sc, 0xf820, sdo_config_1_0xf820, sizeof(sdo_config_1_0xf820));
    ecrt_slave_config_complete_sdo(sc, 0x8000, sdo_config_1_0x8000, sizeof(sdo_config_1_0x8000)); 
    ecrt_slave_config_complete_sdo(sc, 0x8002, sdo_config_1_0x8002, sizeof(sdo_config_1_0x8002)); 

## Compiling

	gcc example_main.c -o example -I /opt/etherlab/include -L /opt/etherlab/lib -lethercat -lpthread -Wl --rpath -Wl /opt/etherlab/lib 