#import "AZFunctions.h"
#import <X11/Xutil.h>
#import <GNUstepGUI/GSDisplayServer.h>
#import <AppKit/AppKit.h>

Display *dpy;
Window root_win;

Atom AZ_WM_STATE;
Atom AZ_NET_CLIENT_LIST;
Atom AZ_NET_CURRENT_DESKTOP;
Atom AZ_NET_WM_DESKTOP;
Atom AZ_NET_WM_WINDOW_TYPE;
Atom AZ_NET_WM_WINDOW_TYPE_DOCK;
Atom AZ_NET_WM_STATE;
Atom AZ_NET_WM_STATE_SKIP_PAGER;
Atom AZ_NET_WM_STATE_SKIP_TASKBAR;
Atom AZ_NET_WM_STATE_STICKY;

void AZInitializeXWindowSystem()
{
  dpy = (Display*)[GSCurrentServer() serverDevice];
  int screen = [[NSScreen mainScreen] screenNumber];
  root_win = RootWindow(dpy, screen);

  /* Atoms */
  AZ_WM_STATE = XInternAtom(dpy, "WM_STATE", False);
  AZ_NET_CLIENT_LIST = XInternAtom(dpy, "_NET_CLIENT_LIST", False);
  AZ_NET_CURRENT_DESKTOP = XInternAtom(dpy, "_NET_CURRENT_DESKTOP", False);
  AZ_NET_WM_DESKTOP = XInternAtom(dpy, "_NET_WM_DESKTOP", False);
  AZ_NET_WM_WINDOW_TYPE = XInternAtom(dpy, "_NET_WM_WINDOW_TYPE", False);
  AZ_NET_WM_WINDOW_TYPE_DOCK = XInternAtom(dpy, "_NET_WM_WINDOW_TYPE_DOCK", False);
  AZ_NET_WM_STATE = XInternAtom(dpy, "_NET_WM_STATE", False);
  AZ_NET_WM_STATE_SKIP_PAGER = XInternAtom(dpy, "_NET_WM_STATE_SKIP_PAGER", False);
  AZ_NET_WM_STATE_SKIP_TASKBAR = XInternAtom(dpy, "_NET_WM_STATE_SKIP_TASKBAR", False);
  AZ_NET_WM_STATE_STICKY = XInternAtom(dpy, "_NET_WM_STATE_STICKY", False);
}

void *AZGetPropertyData(Display *dpy, Window win, 
		        Atom prop, Atom type, int *items)
{
  Atom type_ret;
  int format_ret;
  unsigned long items_ret;
  unsigned long after_ret;
  unsigned char *prop_data;

  prop_data = 0;

  XGetWindowProperty (dpy, win, prop, 0, 0x7fffffff, False,
                      type, &type_ret, &format_ret, &items_ret,
                      &after_ret, &prop_data);
  if (items)
  *items = items_ret;

  return prop_data;
}

BOOL AZGetWindowClass(Display *dpy, Window window, 
		      char **wm_class, char **wm_instance)
{
  XClassHint  *class_hint;

  class_hint = XAllocClassHint();
  if (XGetClassHint(dpy,window,class_hint) == 0) {
    *wm_class = NULL;
    *wm_instance = NULL;
    XFree(class_hint);
    return NO;
  }
  *wm_instance = class_hint->res_name;
  *wm_class = class_hint->res_class;

  XFree(class_hint);
  return YES;
}

BOOL AZIsMyWindow(Display *dpy, Window win)
{
  /* If this is my window, it will called 'process_name'.GNUstep */
  char *wm_class, *wm_instance;
  if (AZGetWindowClass(dpy, win, &wm_class, &wm_instance))
  {
    NSString *name = [[NSProcessInfo processInfo] processName];
    if ((strcmp(wm_class, "GNUstep") == 0) &&
	(strcmp(wm_instance, [name cString]) == 0))
    {
      return YES;
    }
  }
  return NO;
}

BOOL AZIsWindowIconified(Display *dpy, Window win)
{
  unsigned long *data;
  BOOL icon = NO;

  data = AZGetPropertyData(dpy, win, AZ_WM_STATE, AZ_WM_STATE, 0);
  if (data)
  {
    if (data[0] == IconicState)
      icon = YES;
    XFree(data);
  }
  return icon;
}

