#import "AZTaskbar.h"
#import "AZTask.h"
#import "AZTaskbarView.h"
#import "AZFunctions.h"
#import "AZWindow.h"
#import <GNUstepGUI/GSDisplayServer.h>
#import <X11/Xatom.h>
#import <X11/Xutil.h>

@interface GSDisplayServer (AZPrivate)
- (void) processEvent: (XEvent *) event;
@end

static AZTaskbar *sharedInstance;

@implementation AZTaskbar

- (void) readClientList
{
  Window *win;
  int i, count;

  [tasks removeAllObjects];
  win = AZGetPropertyData(dpy, root_win, AZ_NET_CLIENT_LIST, XA_WINDOW, &count);

  if (!win)
  {
    NSLog(@"Error: cannot get client list");
    return;
  }

  for (i = 0; i < count; i++)
  {
    if (AZIsMyWindow(dpy, win[i]) == YES)
      continue;

    AZTask *task = [[AZTask alloc] init];
    [task setXWindow: win[i]];
    [task setName: [NSString stringWithCString: AZGetPropertyData(dpy, win[i], XA_WM_NAME, XA_STRING, 0)]];
    [tasks addObject: task];
    DESTROY(task);

    /* Listen to change on client */
    XSelectInput(dpy, win[i], 
		 (PropertyChangeMask|FocusChangeMask|StructureNotifyMask));
  }

  [panelView setTasks: tasks];
}

- (void) handleDestroyNotify: (XEvent *) event
{
  NSLog(@"Destroy: %d", event->xdestroywindow.window);
}

- (void) handlePropertyNotify: (XEvent *) event
{
  Window win = event->xproperty.window;  
  Atom atom = event->xproperty.atom;

  if (win == root_win)
  {
    if ((atom == AZ_NET_CLIENT_LIST) || (atom == AZ_NET_CURRENT_DESKTOP))
    {
      [self readClientList];
    }
    return;
  }
}

- (void) handleFocusInNotify: (XEvent *) event
{
#if 0
  char *wm_class, *wm_instance;
  if (AZGetWindowClass(dpy, event->xfocus.window, &wm_class, &wm_instance))
  {
    NSLog(@"Focus in: %s.%s (%d)", wm_instance, wm_class, event->xfocus.window);
  }
  else
  {
    NSLog(@"Focus in: %d", event->xfocus.window);
  }
#endif
}

- (void)receivedEvent:(void *)data
                 type:(RunLoopEventType)type
                extra:(void *)extra
              forMode:(NSString *)mode
{
  XEvent event;

  while (XPending(dpy)) 
  {
    XNextEvent (dpy, &event);
    switch (event.type) {
      case Expose:
	/* This is only for AZTaskbar.
	 * Make sure main window is focused (appicon may has the focus).
	 */
	[panelWindow becomeMainWindow];
	[server processEvent: &event];
        break;
      case DestroyNotify:
	/* If main window is not [NSWindow mainWindow],
	 * this may be called. Therefore, we need to terminate manually.
	 */
	if (mainXWindow == event.xdestroywindow.window)
	  [NSApp terminate: self];
	else
	  [self handleDestroyNotify: &event];
	break;
      case PropertyNotify:
	if (AZIsMyWindow(dpy, event.xproperty.window) == YES)
	  [server processEvent: &event];
	else
	  [self handlePropertyNotify: &event];
	break;
      case FocusIn:
	if (AZIsMyWindow(dpy, event.xfocus.window) == YES)
	  [server processEvent: &event];
	else
	  [self handleFocusInNotify: &event];
	break;
      default:
	[server processEvent: &event];
    }
  }
}

- (void) applicationWillFinishLaunching:(NSNotification *)aNotification
{
  tasks = [[NSMutableArray alloc] init];

  server = GSCurrentServer();

  AZInitializeXWindowSystem();

  /* Listen event */
  NSRunLoop     *loop = [NSRunLoop currentRunLoop];
  int xEventQueueFd = XConnectionNumber(dpy);

  [loop addEvent: (void*)(gsaddr)xEventQueueFd
                        type: ET_RDESC
                     watcher: (id<RunLoopEvents>)self
                     forMode: NSDefaultRunLoopMode];

  /* Listen to window closing and opening */
  XSelectInput(dpy, root_win, PropertyChangeMask);
}

- (void) applicationDidFinishLaunching:(NSNotification *)aNotification
{
  /* Setup user interface */
  NSRect rect = NSMakeRect(0, 0, 500, 50);
  panelView = [[AZTaskbarView alloc] initWithFrame: rect];
  panelWindow = [[AZWindow alloc] initWithContentRect: rect
	                     styleMask: NSTitledWindowMask|NSClosableWindowMask
		             backing: NSBackingStoreBuffered
			     defer: YES];
  [panelWindow setContentView: panelView];
  [panelWindow setTitle: @"AZTaskbar"];
  [panelWindow orderFront: self];

  /* Cache main window because if it is closed (destroyed),
   * any attempt to get xwindow from main window (NSWindow) 
   * causes segment fault.
   */
  mainXWindow = [panelWindow xwindow];
  if (mainXWindow == 0)
  {
    NSLog(@"Internal Error: cannot get mainXWindow");
  }

  /* stay in all desktops */
  [panelWindow becomeSticky];

  [self readClientList];
}

- (BOOL) applicationShouldTerminateAfterLastWindowClosed: (id) sender
{
  return YES;
}

- (void) dealloc
{
  DESTROY(tasks);
  DESTROY(panelView);
  DESTROY(panelWindow);
  [super dealloc];
}

+ (AZTaskbar *) sharedTaskbar
{
  if (sharedInstance == nil)
    sharedInstance = [[AZTaskbar alloc] init];
  return sharedInstance;
}

@end

