#import "AZWindow.h"
#import "AZFunctions.h"

@implementation AZWindow
- (id) initWithContentRect: (NSRect)contentRect
                 styleMask: (unsigned int)aStyle
                   backing: (NSBackingStoreType)bufferingType
                     defer: (BOOL)flag
                    screen: (NSScreen*)aScreen
{
  self = [super initWithContentRect: contentRect
                 styleMask: aStyle
                   backing: bufferingType
                     defer: flag
                    screen: aScreen];

  server = GSCurrentServer();

  return self;
}

- (BOOL) canBecomeKeyWindow
{
  return NO;
}

- (Window) xwindow
{
  if (!win)
  {
    void *winptr = [server windowDevice: [self windowNumber]];
    win = *(Window *)winptr;
  }
  return win;
}

- (void) becomeSticky
{
#if 1
  /* stay in all desktops */
  unsigned int value = 0xffffffff;
  XChangeProperty(dpy, [self xwindow], AZ_NET_WM_DESKTOP, XA_CARDINAL, 32,
                  PropModeReplace, (unsigned char*) &value, 1);
#else // NOT working
    Atom state[3];
    state[0] = AZ_NET_WM_STATE_SKIP_PAGER;
    state[1] = AZ_NET_WM_STATE_SKIP_TASKBAR;
    state[2] = AZ_NET_WM_STATE_STICKY;
    XChangeProperty(dpy, [self xwindow], AZ_NET_WM_STATE, XA_ATOM, 32,
                    PropModeReplace, (unsigned char *) state, 3);
#endif
    XSync(dpy, False);
}

- (void) becomeDock
{
  Atom a = AZ_NET_WM_WINDOW_TYPE_DOCK;
  XChangeProperty(dpy, [self xwindow], AZ_NET_WM_WINDOW_TYPE, XA_ATOM, 32,
                  PropModeReplace, (unsigned char *) &a, 1);
}

@end
