#import "AZTask.h"
#import "AZFunctions.h"

@implementation AZTask

- (id) initWithXWindow: (Window) w
{
  self = [super init];
  win = w;
  geometry.origin.x = NSNotFound; // uninitialized
  return self;
}

- (Window) xwindow
{
  return win;
}

- (NSString *) name: (BOOL) refresh
{
  if ((name == nil) || (refresh == YES))
  {
    ASSIGN(name, ([NSString stringWithCString: AZGetPropertyData(dpy, win, XA_WM_NAME, XA_STRING, 0)]));

  }
  return name;
}

- (NSRect) xwindowGeometry: (BOOL) refresh
{
  int x, y;
  unsigned int w, h;

  if ((geometry.origin.x == NSNotFound) || (refresh == YES))
  {
    unsigned int dummy;
    XWindowAttributes win_attr;
    Window junk;

    if (!XGetWindowAttributes(dpy, win, &win_attr))
    {
      if (!XGetGeometry(dpy, win, &junk, &x, &y, &w, &h, &dummy, &dummy))
      {
        x = y = 0;
        w = h = 0;
      }
    }
    else
    {
      XTranslateCoordinates(dpy, win, win_attr.root,
		            -win_attr.border_width,
			    -win_attr.border_width,
			    &x, &y, &junk);
      w = win_attr.width;
      h = win_attr.height;
    }
  }
  geometry = NSMakeRect(x, y, w, h);
  NSLog(@"%@ (%@)", [self name: NO], NSStringFromRect(geometry));
  return geometry;
}

- (void) dealloc
{
  DESTROY(name);
  [super dealloc];
}

@end
