#import "AZPagerView.h"
#import "AZTask.h"
#import "AZFunctions.h"

#define AZSpace 5
#define AZScale 20

@implementation AZPagerView

- (BOOL) acceptsFirstResponder
{
  return YES;
}
- (void) mouseDown: (NSEvent *) event
{
  NSPoint location;
  int index;
  switch ([event type]) {
    case NSLeftMouseDown:
      /* Don't be precise. Users are not precise clicker. */
      location = [event locationInWindow];
      index = (int)(location.x/(AZSpace+desktopSize.width));
      if (index >= num_desk)
	index = num_desk-1;
      AZSendClientMessage(dpy, root_win, AZ_NET_CURRENT_DESKTOP, (long)index, 0, 0, 0, 0);
      current_desk = index;
      /* FIXME: this is not enough to update window.
       * Don't know how to do that.
       */
      [self display];
      break;
    default:
      [super mouseDown: event];
  }
}

- (void) drawRect: (NSRect) rect
{
  NSRect frame;
  int i, count;

  [super drawRect: rect];
  
  /* Background */
  [[NSColor darkGrayColor] set];
  frame = NSMakeRect(0, 0, viewSize.width, viewSize.height);
  NSRectFill(frame);

  for (i = 0; i < num_desk; i++)
  {
    if (i == current_desk)
      [[NSColor whiteColor] set];
    else
      [[NSColor lightGrayColor] set];

    frame = NSMakeRect(AZSpace+(desktopSize.width+AZSpace)*i, AZSpace,
	               desktopSize.width, desktopSize.height);

    NSRectFill(frame);
  }

#if 0
  int i, count = [tasks count];
  for(i = 0; i < count; i++)
  {
    [[tasks objectAtIndex: i] xwindowGeometry: YES];
  }
#endif
}

- (void) setTasks: (NSArray *) t
{
  ASSIGN(tasks, t);
  current_desk = AZCurrentDesktop(dpy);
}

- (void) setNumberOfDesktops: (int) number
{
  num_desk = number;

  /* Calculation */
  NSScreen *scr = [NSScreen mainScreen];
  int w, h;
  w = [scr frame].size.width;
  h = [scr frame].size.height;
  desktopSize = NSMakeSize(w/AZScale, h/AZScale);
  viewSize = NSMakeSize(AZSpace+(num_desk*(desktopSize.width+AZSpace)),
		        AZSpace*2+desktopSize.height);
}

- (NSSize) optimalSize
{
  return viewSize;
}

- (id) initWithFrame: (NSRect) frame
{
  self = [super initWithFrame: frame];
  return self;
}

- (void) dealloc
{
  [super dealloc];
}

@end
