#include "flow_procs.h"
#include "flow_error.h"
#include <sys/stat.h>

using namespace std;

bool ft_init(char *id,ftio *ftio,int fd,ftver *ftver,fts3rec_offsets *fo){
 fterr_setid(id);
 if (ftio_init(ftio,fd,FT_IO_FLAG_READ)<0){
  return false;
 };
 ftio_get_ver(ftio,ftver);
 fts3rec_compute_offsets(fo,ftver);
 return true;
};

bool ft_init_w(ftio *ftio,int fd,ftver *ftver){
 if (ftio_init(ftio,fd,FT_IO_FLAG_WRITE|FT_IO_FLAG_ZINIT)<0){
  return false;
 };
 if (ftio_set_ver(ftio,ftver)<0) {
  return false;
 };
 if (ftio_write_header(ftio)<0) {
  return false;
 };
 ftio_set_z_level(ftio,9);
 return true;
};


void dump_exporters(exporters_vector *exp) {
 exporters_vector::iterator curr=exp->begin();
 exporters_vector::iterator last=exp->end();
 x_debug(4,"Capacity: %i",exp->capacity());
 x_debug(4,"Exporters:");
 while (curr!=last) {
  string dip;
  u_int32 ip=curr->ip;
  ftip_to_dip(&ip,&dip);
  x_debug(4,"%s",dip.c_str());
  curr++;
 };
}

void ftip_to_dip(u_int32 *ftip,string *dip) {
 char ip_buf[64];
 fmt_ipv4(ip_buf,*ftip,FMT_JUST_LEFT);
 dip->append(ip_buf);
};

bool check_path(char *path){
 struct stat stat_buf;
 if (stat(path,&stat_buf)<0){
  x_debug(5,"Not %s , creating.",path);
  if (mkdir(path,0755)<0) {
   if (errno!=EEXIST) {
    return false;
   } else {
    x_debug(5,"Dir exists: %s",path);
   };
  };
 } else {;
  x_debug(5,"Dir exists: %s",path);
 };
 return true;
};
