/*
 *  Fl_Native_Printer.h
 *
 */
#ifdef __APPLE__
#include <Carbon/Carbon.h>
#elif defined(WI3N2)
#include <Windows.h>
#endif


#include <FL/Fl.H>
#include <FL/x.H>
#include <FL/fl_draw.H>

/**
 * @brief Provides an OS-independent interface to printing under MSWindows and Mac OS X.
 *
 This class provides an OS-independent interface to printing under MSWindows and Mac OS X only.
 It allows to use all FLTK drawing, color, and text functions, and to have them operate
 on printed page(s). FLTK clip functions should not be used in a print context,
 member function setclip() is to be used instead.
 */
class Fl_Native_Printer {
   int s_topmargin;
   int s_leftmargin;
#ifdef __APPLE__
   PMPrintSession  printSession;
   PMPageFormat    pageFormat;
   PMPrintSettings printSettings;
#elif defined(WIN32)
   int   abortPrint;
   PRINTDLG      pd;
   HDC           hPr;
   int           prerr;
#endif
public:
  /** 
   @brief The constructor.
   */
  Fl_Native_Printer(void);
  /**
   @brief Starts a print job.
   *
   @param pagecount the total number of pages of the job
   @param frompage is returned set to the first page the user wants printed
   @param topage is returned set to the last page the user wants printed
   @return 0 iff OK
   */
  int startjob(int pagecount, int *frompage, int *topage);
  /**
   @brief Starts a new printed page
   *
   @param left_margin the offset from the left border of the printable page area that will
   have 0 coordinate for FLTK drawing functions
   @param top_margin the offset from the top border of the printable page area that will
   have 0 coordinate for FLTK drawing functions
   @return 0 iff error
   */
  int startpage (int left_margin = 0, int top_margin = 0);
  /**
   @brief Computes the origin and size of the printable area of the page.
   *
   Values are in the same unit
   as that used by FLTK drawing functions. This unit accounts for the effect of the
   startpage() function when getprintablerect() is called after startpage().
   @return 0 iff error.
   */
  int getprintablerect(int *x, int *y, int *w, int *h);
  /**
   @brief Sets the clip zone for further drawing operations. 
   *
   A new clip call resets any previous one.
   @return 0 iff error.
   */
  int setclip(int x, int y, int w, int h);
  /**
   @brief To be called at the end of each page.
   *
   @return 0 iff error.
   */
  int endpage (void);
  /**
   @brief To be called at the end of a print job.
   */
  void endjob (void);
};
