/*
 *  fl_native_printer_mac.cxx
 *
 */
#ifdef __APPLE__

#include <Carbon/Carbon.h>
#import <Cocoa/Cocoa.h>
#ifndef NSINTEGER_DEFINED //appears with 10.5 in NSObjCRuntime.h
#if defined(__LP64__) && __LP64__
typedef long NSInteger;
typedef unsigned long NSUInteger;
#else
typedef int NSInteger;
typedef unsigned int NSUInteger;
#endif
#endif

#include <FL/Fl_Native_Printer.H>
#include <FL/fl_ask.H>

extern CGContextRef fl_gc;
extern void fl_quartz_restore_line_style_();

Fl_Native_Printer::Fl_Native_Printer(void)
{
   s_topmargin = 0;
   s_leftmargin = 0;
}


int Fl_Native_Printer::startjob (int pagecount, int *frompage, int *topage)
//printing using a Quartz graphics context
//returns 0 iff OK
{
  OSStatus status;
  Fl_X::q_release_context();
#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5
  if( [NSPrintPanel instancesRespondToSelector:@selector(runModalWithPrintInfo:)] &&
     [NSPrintInfo instancesRespondToSelector:@selector(PMPrintSession)] ) {
    NSAutoreleasePool *localPool;
    localPool = [[NSAutoreleasePool alloc] init]; 
    NSPrintInfo *info = [NSPrintInfo sharedPrintInfo];
    NSPageLayout *layout = [NSPageLayout pageLayout];
    NSInteger retval = [layout runModal];
    if(retval == NSOKButton) {
      NSPrintPanel *panel = [NSPrintPanel printPanel];
      retval = (NSInteger)[panel runModalWithPrintInfo:info];//from 10.5 only
    }
    if(retval != NSOKButton) {
      Fl::first_window()->show();
      [localPool release];
      return 1;
    }
    printSession = (PMPrintSession)[info PMPrintSession];
    pageFormat = (PMPageFormat)[info PMPageFormat];
    printSettings = (PMPrintSettings)[info PMPrintSettings];
    UInt32 from32, to32;
    PMGetFirstPage(printSettings, &from32); *frompage = (int)from32;
    PMGetLastPage(printSettings, &to32); *topage = (int)to32;
    if(*topage > pagecount) *topage = pagecount;
    status = PMSessionBeginCGDocumentNoDialog(printSession, printSettings, pageFormat);
    [localPool release];
  }
  else {
#endif
    
#if !__LP64__
    Boolean accepted;
    status = PMCreateSession(&printSession);
    if (status != noErr) return 1;
    status = PMCreatePageFormat(&pageFormat);
    status = PMSessionDefaultPageFormat(printSession, pageFormat);
    if (status != noErr) return 1;
    status = PMSessionPageSetupDialog(printSession, pageFormat, &accepted);
    if (status != noErr || !accepted) {
      Fl::first_window()->show();
      return 1;
    }
    status = PMCreatePrintSettings(&printSettings);
    if (status != noErr || printSettings == kPMNoPrintSettings) return 1;
    status = PMSessionDefaultPrintSettings (printSession, printSettings);
    if (status != noErr) return 1;
    PMSetPageRange(printSettings, 1, (UInt32)kPMPrintAllPages);
    status = PMSessionPrintDialog(printSession, printSettings, pageFormat, &accepted);
    if (!accepted) status = kPMCancel;
    if (status != noErr) {
      Fl::first_window()->show();
      return 1;
    }
    UInt32 from32, to32;
    PMGetFirstPage(printSettings, &from32); *frompage = (int)from32;
    PMGetLastPage(printSettings, &to32); *topage = (int)to32;
    if(*topage > pagecount) *topage = pagecount;
    CFStringRef mystring[1];
    mystring[0] = kPMGraphicsContextCoreGraphics;
    CFArrayRef array = CFArrayCreate(NULL, (const void **)mystring, 1, &kCFTypeArrayCallBacks);
    status = PMSessionSetDocumentFormatGeneration(printSession, kPMDocumentFormatDefault, array, NULL);
    CFRelease(array);
    status = PMSessionBeginDocumentNoDialog(printSession, printSettings, pageFormat);
#endif //__LP64__
    
#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5
  }
#endif
  if (status != noErr) return 1;
  s_topmargin = s_leftmargin = 0;
  return 0;
}


int Fl_Native_Printer::getprintablerect(int *x, int *y, int *w, int *h)
//returns TRUE iff OK
{
  OSStatus status;
  PMRect pmRect;
  
  status = PMGetAdjustedPageRect(pageFormat, &pmRect);
  if (status != noErr) return FALSE;
  
  *x = (int)pmRect.left - s_leftmargin;
  *y = (int)pmRect.top - s_topmargin;
  *w = (int)pmRect.right - *x + 1 - s_leftmargin;
  *h = (int)pmRect.bottom - *y + 1 - s_topmargin;
  return TRUE;
}

int Fl_Native_Printer::startpage (int left_margin, int top_margin)
{	
  OSStatus status = PMSessionBeginPageNoDialog(printSession, pageFormat, NULL);
#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4
  if ( PMSessionGetCGGraphicsContext != NULL ) {
    status = PMSessionGetCGGraphicsContext(printSession, &fl_gc);
  }
  else {
#endif
#if ! __LP64__
    status = PMSessionGetGraphicsContext(printSession,NULL,(void **)&fl_gc);
#endif
#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4
  }
#endif
  PMRect pmRect;

  PMPaper paper;
  PMGetPageFormatPaper(pageFormat, &paper);
  PMPaperMargins margins;
  PMPaperGetMargins(paper, &margins);
  
  status = PMGetAdjustedPageRect(pageFormat, &pmRect);
  double h = pmRect.bottom - pmRect.top;
  s_topmargin = top_margin; 
  s_leftmargin = left_margin;
  CGContextTranslateCTM(fl_gc, margins.left + left_margin, margins.bottom - top_margin + h -0.5f);
  CGContextScaleCTM(fl_gc, 1.0f, -1.0f);
  fl_quartz_restore_line_style_();
  CGContextSaveGState(fl_gc);
  return status == noErr;
}

int Fl_Native_Printer::setclip(int x, int y, int w, int h)
{
  Rect r;
  
  r.top = y; r.left = x; r.bottom = y + h -0.9; r.right = x + w -0.9;
  CGRect cgr;
  cgr.origin.x = r.left;
  cgr.origin.y = r.top;
  cgr.size.width = r.right - r.left;
  cgr.size.height = r.bottom - r.top;
  CGContextRestoreGState(fl_gc);
  CGContextSaveGState(fl_gc);
  CGContextClipToRect(fl_gc, cgr); 
  return TRUE;
}

int Fl_Native_Printer::endpage (void)
{	
  CGContextFlush(fl_gc);
  CGContextRestoreGState(fl_gc);
  OSStatus status = PMSessionEndPageNoDialog(printSession);
  return status == noErr;
}

void Fl_Native_Printer::endjob (void)
{
  OSStatus status;
  
  status = PMSessionError(printSession);
  if (status != noErr) {
    fl_alert ("PM Session error %d", status);
  }
  PMSessionEndDocumentNoDialog(printSession);
  fl_gc = 0;
  Fl::first_window()->show();
}


#endif // __APPLE__

