/*
 *  fl_native_printer_win32.cxx
 */

#ifdef WIN32

#include <FL/Fl_Native_Printer.H>
#include <FL/fl_ask.H>

extern HWND fl_window;

Fl_Native_Printer::Fl_Native_Printer(void)
{
  hPr = NULL;
}

static void WIN_SetupPrinterDeviceContext(HDC prHDC)
{
  if ( !prHDC ) return;
  
  fl_window = 0;
  fl_gc = prHDC;
  SetMapMode(prHDC, MM_ANISOTROPIC);
  SetTextAlign(prHDC, TA_BASELINE|TA_LEFT);
  SetBkMode(prHDC, TRANSPARENT);	
  HWND screenHwnd = GetDesktopWindow();
  HDC  screenDC   = GetDC( screenHwnd );
  
  /* NOTE:  for video devices, the logical inch IS NOT == physical inch! */
  SetWindowExtEx(prHDC, GetDeviceCaps(screenDC, LOGPIXELSX),
		 GetDeviceCaps(screenDC, LOGPIXELSY), NULL);
  SetViewportExtEx(prHDC, GetDeviceCaps(prHDC, LOGPIXELSX),
		   GetDeviceCaps(prHDC, LOGPIXELSY), NULL);
  
  ReleaseDC(screenHwnd, screenDC);
}


int Fl_Native_Printer::startjob (int pagecount, int *frompage, int *topage)
// returns 0 iff OK
{
  DWORD       commdlgerr;
  DOCINFO     di;
  char        docName [256];
  int err = 0;
  
  abortPrint = FALSE;
  memset (&pd, 0, sizeof (PRINTDLG));
  pd.lStructSize = sizeof (PRINTDLG);
  pd.hwndOwner = GetForegroundWindow();
  pd.Flags = PD_RETURNDC | PD_USEDEVMODECOPIESANDCOLLATE | PD_NOSELECTION;
  pd.nMinPage = 1;
  pd.nMaxPage = pagecount;
  if (PrintDlg (&pd) != 0) {
    hPr = pd.hDC;
    if (hPr != NULL) {
      WIN_SetupPrinterDeviceContext (hPr);
      strcpy (docName, "Seaview");
      memset(&di, 0, sizeof(DOCINFO));
      di.cbSize = sizeof (DOCINFO);
      di.lpszDocName = (LPCSTR) docName;
      prerr = StartDoc (hPr, &di);
      if (prerr < 1) {
	abortPrint = TRUE;
	fl_alert ("StartDoc error %d", prerr);
	err = 1;
      }
    } else {
      commdlgerr = CommDlgExtendedError ();
      fl_alert ("Unable to create print context, error %lu",
		(unsigned long) commdlgerr);
      err = 1;
    }
  } else {
    err = 1;
  }
  if(!err) {
    if((pd.Flags & PD_PAGENUMS) != 0 ) {
      *frompage = pd.nFromPage;
      *topage = pd.nToPage;
    }
    else {
      *frompage = 1;
      *topage = pagecount;
    }
    s_topmargin = 0;
    s_leftmargin = 0;
  }
  return err;
}

void Fl_Native_Printer::endjob (void)
{
  if (hPr != NULL) {
    if (! abortPrint) {
      prerr = EndDoc (hPr);
      if (prerr < 0) {
	fl_alert ("EndDoc error %d", prerr);
      }
    }
    DeleteDC (hPr);
    if (pd.hDevMode != NULL) {
      GlobalFree (pd.hDevMode);
    }
    if (pd.hDevNames != NULL) {
      GlobalFree (pd.hDevNames);
    }
  }
}


int Fl_Native_Printer::setclip(int x, int y, int w, int h)
{
  long left, right, top, bottom;
  POINT    pt;
  
  left = x - 1; right = x + w;
  top = y - 1; bottom = y + h ;
  
  if (hPr == NULL) return FALSE;
  
  pt.x = left;
  pt.y = bottom;
  LPtoDP(hPr, &pt, 1);
  left   = pt.x;
  bottom = pt.y;
  
  pt.x = right;
  pt.y = top;
  LPtoDP(hPr, &pt, 1);
  right = pt.x;
  top   = pt.y;
  
  HRGN hRgnClip = CreateRectRgn (left, top, right, bottom);
  SelectClipRgn (hPr, hRgnClip);
  DeleteObject (hRgnClip);
  return TRUE;
}


int Fl_Native_Printer::getprintablerect(int *x, int *y, int *w, int *h)
{
  POINT         physPageSize;
  POINT         pixelsPerInch;
    
  if (hPr == NULL) return FALSE;
  SetWindowOrgEx(fl_gc, 0, 0, NULL);
  
  physPageSize.x = GetDeviceCaps(hPr, HORZRES);
  physPageSize.y = GetDeviceCaps(hPr, VERTRES);
  DPtoLP(hPr, &physPageSize, 1);
  *w = physPageSize.x + 1;
  *h = physPageSize.y + 1;
  pixelsPerInch.x = GetDeviceCaps(hPr, LOGPIXELSX);
  pixelsPerInch.y = GetDeviceCaps(hPr, LOGPIXELSY);
  DPtoLP(hPr, &pixelsPerInch, 1);
  *x = (pixelsPerInch.x / 4) - s_leftmargin;
  *w -= (pixelsPerInch.x / 2);
  *y = (pixelsPerInch.y / 4) - s_topmargin;
  *h -= (pixelsPerInch.y / 2);
  
  SetWindowOrgEx(fl_gc, - s_leftmargin, - s_topmargin, NULL);
  return TRUE;
}

int Fl_Native_Printer::startpage (int left_margin, int top_margin)
{
  int  rsult, x, y, w, h;
  
  rsult = TRUE;
  if (hPr != NULL) {
    WIN_SetupPrinterDeviceContext (hPr);
    prerr = StartPage (hPr);
    if (prerr < 0) {
      fl_alert ("StartPage error %d", prerr);
      rsult = FALSE;
    }
    fl_window = 0;
    fl_gc = hPr;
    getprintablerect(&x, &y, &w, &h);
    SetWindowOrgEx(fl_gc, -x - left_margin, -y - top_margin, NULL);
    s_topmargin =  y + top_margin;
    s_leftmargin = x + left_margin;
  }
  return rsult;
}

int Fl_Native_Printer::endpage (void)
{
  int  rsult;
  
  rsult = TRUE;
  if (hPr != NULL) {
    prerr = EndPage (hPr);
    if (prerr < 0) {
      abortPrint = TRUE;
      fl_alert ("EndPage error %d", prerr);
      rsult = FALSE;
    }
  } else {
    rsult = FALSE;
  }
  return rsult;
}


#endif // WIN32

