/*
 *  fl_native_printer_mac.cxx
 *
 */
#ifdef __APPLE__

#include <Carbon/Carbon.h>
#import <Cocoa/Cocoa.h>

#include <FL/Fl_Native_Printer.H>
#include <FL/fl_ask.H>

extern void fl_quartz_restore_line_style_();

Fl_Native_Printer::Fl_Native_Printer(void)
{
   y_offset = 0;
   x_offset = 0;
}


int Fl_Native_Printer::startjob (int pagecount, int *frompage, int *topage)
//printing using a Quartz graphics context
//returns 0 iff OK
{
  OSStatus status;
  Fl_X::q_release_context();
#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5
  if( [NSPrintPanel instancesRespondToSelector:@selector(runModalWithPrintInfo:)] &&
     [NSPrintInfo instancesRespondToSelector:@selector(PMPrintSession)] ) {
    NSAutoreleasePool *localPool;
    localPool = [[NSAutoreleasePool alloc] init]; 
    NSPrintInfo *info = [NSPrintInfo sharedPrintInfo];
    NSPageLayout *layout = [NSPageLayout pageLayout];
    NSInteger retval = [layout runModal];
    if(retval == NSOKButton) {
      NSPrintPanel *panel = [NSPrintPanel printPanel];
      retval = (NSInteger)[panel runModalWithPrintInfo:info];//from 10.5 only
    }
    if(retval != NSOKButton) {
      Fl::first_window()->show();
      [localPool release];
      return 1;
    }
    printSession = (PMPrintSession)[info PMPrintSession];
    pageFormat = (PMPageFormat)[info PMPageFormat];
    printSettings = (PMPrintSettings)[info PMPrintSettings];
    UInt32 from32, to32;
    PMGetFirstPage(printSettings, &from32); 
    if (frompage) *frompage = (int)from32;
    PMGetLastPage(printSettings, &to32); 
    if (topage) *topage = (int)to32;
    if(topage && *topage > pagecount) *topage = pagecount;
    status = PMSessionBeginCGDocumentNoDialog(printSession, printSettings, pageFormat);
    [localPool release];
  }
  else {
#endif
    
#if !__LP64__
    Boolean accepted;
    status = PMCreateSession(&printSession);
    if (status != noErr) return 1;
    status = PMCreatePageFormat(&pageFormat);
    status = PMSessionDefaultPageFormat(printSession, pageFormat);
    if (status != noErr) return 1;
    status = PMSessionPageSetupDialog(printSession, pageFormat, &accepted);
    if (status != noErr || !accepted) {
      Fl::first_window()->show();
      return 1;
    }
    status = PMCreatePrintSettings(&printSettings);
    if (status != noErr || printSettings == kPMNoPrintSettings) return 1;
    status = PMSessionDefaultPrintSettings (printSession, printSettings);
    if (status != noErr) return 1;
    PMSetPageRange(printSettings, 1, (UInt32)kPMPrintAllPages);
    status = PMSessionPrintDialog(printSession, printSettings, pageFormat, &accepted);
    if (!accepted) status = kPMCancel;
    if (status != noErr) {
      Fl::first_window()->show();
      return 1;
    }
    UInt32 from32, to32;
    PMGetFirstPage(printSettings, &from32); 
    if (frompage) *frompage = (int)from32;
    PMGetLastPage(printSettings, &to32); 
    if (topage) *topage = (int)to32;
    if(topage && *topage > pagecount) *topage = pagecount;
    CFStringRef mystring[1];
    mystring[0] = kPMGraphicsContextCoreGraphics;
    CFArrayRef array = CFArrayCreate(NULL, (const void **)mystring, 1, &kCFTypeArrayCallBacks);
    status = PMSessionSetDocumentFormatGeneration(printSession, kPMDocumentFormatDefault, array, NULL);
    CFRelease(array);
    status = PMSessionBeginDocumentNoDialog(printSession, printSettings, pageFormat);
#endif //__LP64__
    
#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_5
  }
#endif
  if (status != noErr) return 1;
  y_offset = x_offset = 0;
  return 0;
}

int Fl_Native_Printer::getprintablerect(int *x, int *y, int *w, int *h)
//returns 0 iff OK
{
  OSStatus status;
  PMRect pmRect;
  
  status = PMGetAdjustedPageRect(pageFormat, &pmRect);
  if (status != noErr) return 1;
  
  *x = (int)pmRect.left;
  *y = (int)pmRect.top;
  *w = (int)(pmRect.right - *x) / scale_x + 1;
  *h = (int)(pmRect.bottom - *y) / scale_y + 1;
  return 0;
}

void Fl_Native_Printer::setorigin(int x, int y)
{
  x_offset = x;
  y_offset = y;
  CGContextRestoreGState(fl_gc);
  CGContextRestoreGState(fl_gc);
  CGContextSaveGState(fl_gc);
  CGContextScaleCTM(fl_gc, scale_x, scale_y);
  CGContextTranslateCTM(fl_gc, x, y);
  CGContextSaveGState(fl_gc);
}

void Fl_Native_Printer::rescale (float s_x, float s_y)
{
  scale_x = s_x;
  scale_y = s_y;
  CGContextRestoreGState(fl_gc);
  CGContextRestoreGState(fl_gc);
  CGContextSaveGState(fl_gc);
  CGContextScaleCTM(fl_gc, scale_x, scale_y);
  CGContextTranslateCTM(fl_gc, x_offset, y_offset);
  CGContextSaveGState(fl_gc);
}

int Fl_Native_Printer::startpage (void)
{	
  OSStatus status = PMSessionBeginPageNoDialog(printSession, pageFormat, NULL);
#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4
  if ( PMSessionGetCGGraphicsContext != NULL ) {
    status = PMSessionGetCGGraphicsContext(printSession, &fl_gc);
  }
  else {
#endif
#if ! __LP64__
    status = PMSessionGetGraphicsContext(printSession,NULL,(void **)&fl_gc);
#endif
#if MAC_OS_X_VERSION_MAX_ALLOWED >= MAC_OS_X_VERSION_10_4
  }
#endif
  PMRect pmRect;
  float win_scale_x, win_scale_y; // scaling to have same sizes on screen and paper

  PMPaper paper;
  PMGetPageFormatPaper(pageFormat, &paper);
  PMPaperMargins margins;
  PMPaperGetMargins(paper, &margins);
  
  status = PMGetAdjustedPageRect(pageFormat, &pmRect);
  double h = pmRect.bottom - pmRect.top;
  y_offset = 0; 
  x_offset = 0;
  scale_x = scale_y = 1;
  /*NSDictionary *dict = [[(NSWindow*)fl_xid(Fl_Window::current()) screen] deviceDescription];
  NSValue *val = [dict objectForKey:@"NSDeviceSize"];
  NSSize size;
  [val getValue:&size];*/
  //win_scale_x = win_scale_y = 6.4/9.5; // an empirical screen/paper comparison
  win_scale_x = win_scale_y = 1;
  CGContextTranslateCTM(fl_gc, margins.left, margins.bottom + h - 0.5f);
  CGContextScaleCTM(fl_gc, win_scale_x, - win_scale_y);
  fl_quartz_restore_line_style_();
  CGContextSetShouldAntialias(fl_gc, false);
  CGContextSaveGState(fl_gc);
  CGContextSaveGState(fl_gc);
  fl_window = (void *)1; // TODO: something better
  fl_clip_region(0);
  return status != noErr;
}

int Fl_Native_Printer::endpage (void)
{	
  CGContextFlush(fl_gc);
  CGContextRestoreGState(fl_gc);
  CGContextRestoreGState(fl_gc);
  OSStatus status = PMSessionEndPageNoDialog(printSession);
  return status != noErr;
}

void Fl_Native_Printer::endjob (void)
{
  OSStatus status;
  
  status = PMSessionError(printSession);
  if (status != noErr) {
    fl_alert ("PM Session error %d", status);
  }
  PMSessionEndDocumentNoDialog(printSession);
  fl_gc = 0;
  Fl::first_window()->show();
}

#endif // __APPLE__

