/*
 *  Fl_Printer.cxx
 *  FLTK
 *
 */

#ifdef __APPLE__
#include <src/Fl_Printer_mac.mm>
#elif defined(WIN32)
#include <src/Fl_Printer_win32.cxx>
#endif

static int is_child(Fl_Widget *child, Fl_Widget *parent)
{
  while(1) {
    child = child->parent();
    if(child == NULL) return 0;
    if(child == parent) return 1;
  }
}

void Fl_Printer::print_widget(Fl_Widget* widget, int delta_x, int delta_y) 
{ 
  int old_x, old_y;
  if ( ! widget->visible() ) return;
  widget->damage(FL_DAMAGE_ALL); 
  origin(&old_x, &old_y);
  origin(old_x + delta_x, old_y + delta_y);
  widget->draw();
  origin(old_x, old_y);
  //find all windows that are within widget, and draw them
  Fl_Window *win = Fl::first_window();
  while(win) {
    if(win->visible() && is_child(win, widget) ) {
      win->damage(FL_DAMAGE_ALL); 
      origin(&old_x, &old_y);
      origin(old_x + delta_x + win->x(), old_y + delta_y + win->y());
      ((Fl_Widget*)win)->draw();
      origin(old_x, old_y);
    }
    win = Fl::next_window(win);
  }
}

void Fl_Printer::origin(int *x, int *y)
{
  if (x) *x = x_offset;
  if (y) *y = y_offset;
}


