
package splitter;

import java.util.*;
import java.awt.Color;

import org.apache.fop.area.Area;
import org.apache.fop.area.*;
import org.apache.fop.datatypes.ColorType;
import org.apache.fop.traits.*;


/**
 * Block has a height and possibly child blocks.
 */
public class BlockLM implements LM {
    LM parent;
    Block currentBlock = null;
    int height = 0;

    int keepWithPrevious;
    int keepTogether;
    int keepWithNext;
    public static final int KEEP_AUTO = 0;
    public static final int KEEP_ALWAYS = -1;

    // todo - column keeps

    List childBlocks = null;

    List breaks = null;

    public BlockLM() {
    }

    public void setParent(LM p) {
        parent = p;
    }

    public LM getParentLM() {
        return parent;
    }

    public int getHeight() {
        return height;
    }

    /**
     * Randomly generate this block and children.
     * This is to simulate the blocks in a real document.
     */
    public void randomGenerate(int depth) {
        // probablity of children is 50% - 10 x depth
        boolean child = (Math.random() - 0.5 - depth / 20.0) > 0;
        if (child) {
            childBlocks = new ArrayList();
            int num = (int)(Math.random() * 10) + 1;
            //System.out.println("Block-" + depth + " with " + num + " child blocks");
            for (int count = 0; count < num; count++) {
                BlockLM block = new BlockLM();
                block.setParent(this);
                block.randomGenerate(depth + 1);
                childBlocks.add(block);
            }
        } else {
            // a block with the height set is like a single object
            // that cannot be split
            height = 12000;
            boolean line = Math.random() > 0.2;
            if (!line) {
                height = (int)(Math.random() * 100) * 1000;
            }
            //System.out.println("Block-" + depth + " height " + height);
        }

        boolean keep = Math.random() > 0.9;
        if (keep) {
            keepWithPrevious = (int)(Math.random() * 9) + 1;
        }
        keep = Math.random() > 0.9;
        if (keep) {
            keepWithNext = (int)(Math.random() * 9) + 1;
        }
        keep = Math.random() > 0.9;
        if (keep) {
            keepTogether = (int)(Math.random() * 9) + 1;
        }
    }

    // create break tree that is stored inside the layout handlers
    // the optimum break is selected
    // it is then possible to move the breaks forwards or backwards
    // to find the best result for all breaks in the set
    public boolean findBreaks(FlowContext flowc, Context context, BPDCalculator calc, BreakMark last) {
        if (childBlocks != null) {

            int start = 0;
            if (last != null) {
                LM currentchild = last.getChildOf(this);
                if (currentchild != null) {
                    start = childBlocks.indexOf(currentchild);
                }
            }

            int height = 0;
            int h = 0;
            boolean found = false;
            for (int count = start; count < childBlocks.size(); count++) {
                BlockLM block = (BlockLM)childBlocks.get(count);
                found = block.findBreaks(flowc, context, calc, last);
                h += block.getHeight();
                if (found) {
                    break;
                }
            }
            height = h;
            return found;
        } else {
            if (breaks == null) {
                breaks = new ArrayList();
            }
            if (last != null && last.getLM() == this) {
                return false;
            }

            BreakMark bm = new BreakMark(this, 0);
            int dist = calc.calculateTo(last, bm, 0);
            //System.out.println("Block dist: " + dist + ":" + breaks);
            int constraint = getConstraint(bm, true);
            //System.out.println("Block constraint: " + constraint);
            bm.setConstraint(constraint);
            bm.setDistance(dist);
            breaks.add(bm);
            BreakMark best = flowc.getBestBreak();
            if (best == null) {
                flowc.setBestBreak(bm);
            } else if (bm.getDistance() > 0) {
                if (bm.isBetterThan(best)) {
                    flowc.setBestBreak(bm);
                }
            } else {
                flowc.setNextBreak(bm);
                return true;
            }
        }
        return false;
    }

    public int distanceTo(BreakMark from, BreakMark lm) {
        if (childBlocks != null) {
            int start = 0;
            if (from != null) {
                LM currentchild = from.getChildOf(this);
                if (currentchild != null) {
                    start = childBlocks.indexOf(currentchild);
                }
            }
            int end = childBlocks.size();
            if (lm != null) {
                LM tochild = lm.getChildOf(this);
                if (tochild != null) {
                    end = childBlocks.indexOf(tochild) + 1;
                }
            }

            int dist = 0;
            for (int count = start; count < end; count++) {
                BlockLM block = (BlockLM)childBlocks.get(count);
                dist += block.distanceTo(from, lm);
            }
            return dist;
        } else {
            if (from != null && from.getLM() == this) {
                return 0;
            }
            return height;
        }
    }

    /**
     * Get the constraint for this block with the keep together
     * keep with next and keep with previous on next.
     */
    public int getConstraint(BreakMark bm, boolean isLast) {
        if (childBlocks != null) {
            int end = childBlocks.size();
            LM child = bm.getChildOf(this);
            int pos = 0;
            if (child != null) {
                pos = childBlocks.indexOf(child);
            }
            boolean last = false;
            int prev = 0;
            if (pos == end - 1) {
                last = isLast;
            } else if (isLast) {
                // check keep previous
                LM next = (LM)childBlocks.get(pos + 1);
                prev = next.getPreviousConstraint();
            }
            int con = parent.getConstraint(bm, last);
            if (con != -1 && (prev > con || prev == -1)) {
                con = prev;
            }
            if (last && con != -1 && (keepWithNext > con || keepWithNext == -1)) {
                con = keepWithNext;
            } else if (con != -1 && (keepTogether > con || keepTogether == -1)) {
                con = keepTogether;
            }
            return con;
        } else {
            // only keep with next matters
            int con = parent.getConstraint(bm, true);
            if (con != -1 && (keepWithNext > con || keepWithNext == -1)) {
                con = keepWithNext;
            }
            return con;
        }
    }

    public int getPreviousConstraint() {
        if (childBlocks != null && childBlocks.size() > 0) {
            LM first = (LM)childBlocks.get(0);
            int prev = first.getPreviousConstraint();
            if (prev != -1 && (keepWithPrevious > prev || keepWithPrevious == -1)) {
                prev = keepWithPrevious;
            }
            return prev;
        } else {
            return keepWithPrevious;
        }
    }

/*
can get next break, starting at null
only will get next break that is a child of this LM
ending in null

for lm's like table, list, it can get next LM from each cell
from this it can get the distance and associated out of line
areas
that can be used for a break on a table row

*/

    public void addAreas(Context context, BreakMark last, BreakMark current, Color colour) {
        // colours are in groups with changing shade
        
        // coloured according to page/column
        // block with keep previous has top border
        
        // block with keep together has left side border
        
        // block with keep next has bottom border

        if (childBlocks != null) {
            Block bl = new Block();
            currentBlock = bl;
            int start = 0;
            if (last != null) {
                LM currentchild = last.getChildOf(this);
                if (currentchild != null) {
                    start = childBlocks.indexOf(currentchild);
                }
            }
            int end = childBlocks.size();
            if (current != null) {
                LM tochild = current.getChildOf(this);
                if (tochild != null) {
                    end = childBlocks.indexOf(tochild) + 1;
                }
            }

            int h = 0;
                int r = colour.getRed();
                r = r - 15;
                if (r < 0) r = 0;
                int g = colour.getGreen();
                g = g - 15;
                if (g < 0) g = 0;
                int b = colour.getBlue();
                b = b - 15;
                if (b < 0) b = 0;
            for (int count = start; count < end; count++) {
                BlockLM block = (BlockLM)childBlocks.get(count);
                block.addAreas(context, last, current, new Color(r, g, b));
                h += block.getHeight();
            }
            height = h;
            bl.setHeight(height);
            parent.addArea(bl);

            // colouring for testing
            if (start == 0 && keepWithPrevious != 0) {
                ColorType col = new ColorType(0.5f, 0.5f, 0.5f);
                BorderProps bps = new BorderProps(0, 1000, col);
                bl.addTrait(Trait.BORDER_BEFORE, bps);
            }
            if ((end == childBlocks.size() - 1) && keepWithNext != 0) {
                ColorType col = new ColorType(0.5f, 0.5f, 0.5f);
                BorderProps bps = new BorderProps(0, 1000, col);
                bl.addTrait(Trait.BORDER_AFTER, bps);
            }
            if (keepTogether != 0) {
                ColorType col = new ColorType(0.5f, 0.5f, 0.5f);
                BorderProps bps = new BorderProps(0, 1000, col);
                bl.addTrait(Trait.BORDER_START, bps);
            }
            Trait.Background tb = new Trait.Background();
            tb.color = new ColorType(colour.getRed() / 256f, colour.getGreen() / 256f, colour.getBlue() / 256f);
            bl.addTrait(Trait.BACKGROUND, tb);
            bl.setWidth(340000);
        } else {
            if (last != null && last.getLM() == this) {
                // this is a hack to make sure height is not counted
                height = 0;
                return;
            }
            Block bl = new Block();
            currentBlock = bl;
            bl.setHeight(height);
            bl.setWidth(340000);
            parent.addArea(bl);
        }

        currentBlock = null;
    }

    public void addArea(Area area) {
        currentBlock.addBlock((Block)area);
    }
}
