
package splitter;

import java.util.*;

import org.apache.fop.area.MinOptMax;

/**
 * The break mark is a mark for a break in the break tree.
 * It is possible to adjust the break mark forwards or backwards
 * and to then calculate the constraints broken, distance
 */
public class BreakMark {
    int constaintBroken = 0;
    int distance;
    LM layoutM;
    int position;

    public BreakMark(LM lm, int pos) {
        layoutM = lm;
        position = pos;
    }

    public LM getLM() {
        return layoutM;
    }

    public List getAncestors() {
        List list = new ArrayList();
        LM parent;
        parent = layoutM;
        list.add(parent);
        while ((parent = parent.getParentLM()) != null) {
            list.add(parent);
        }
        return list;
    }

    // get the child of the parent parameter
    // that is in the break ancestor path
    public LM getChildOf(LM parent) {
        LM lm = getLM();
        if (lm == parent) {
            return null;
        }
        LM p = lm.getParentLM();
        while (p != null) {
            if (p == parent) {
                return lm;
            }
            lm = p;
            p = lm.getParentLM();
        }
        return null;
    }

    public void setDistance(int dist) {
        distance = dist;
    }

    public int getDistance() {
        return distance;
    }

    public void setConstraint(int cont) {
        constaintBroken = cont;
    }

    public int getConstraint() {
        return constaintBroken;
    }

    public boolean isBetterThan(BreakMark other) {
        if (getDistance() < other.getDistance()) {
            if (constaintBroken == -1) {
                return other.getConstraint() == -1;
            }
            if (other.getConstraint() == -1) {
                return true;
            }
            return constaintBroken <= other.getConstraint();
        }
        return false;
    }
}
