

package splitter;

import java.awt.*;
import java.util.*;
import java.util.List;

import org.apache.fop.area.AreaTree;
import org.apache.fop.area.Area;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.*;

/**
 * Flow contains blocks.
 * 
 *
 */
public class FlowLM implements LM {
    AreaTree areaTree;
    PageViewport curPage;
    Span curSpan;
    BodyRegion curBody;
    Flow curFlow;
    PageLM pager = new PageLM();
    List blocks = new ArrayList();
    List breakList;

    public void setAreaTree(AreaTree at) {
        areaTree = at;
    }

    public LM getParentLM() {
        return null;
    }

    public void createBlocks() {
        int num = (int)(Math.random() * 20) + 1;
        System.out.println("Flow with " + num + " blocks");
        for (int count = 0; count < num; count++) {
            BlockLM block = new BlockLM();
            block.setParent(this);
            block.randomGenerate(0);
            blocks.add(block);
        }
    }

    public void findBreaks() {
        breakList = new ArrayList();
        FlowContext flowcontext = new FlowContext();
        Context context = new Context();
        BPDCalculator calc = new BPDCalculator(this);
        boolean found = false;
        BreakMark best = null;

        for (int count = 0; count < blocks.size(); count++) {
            BlockLM block = (BlockLM)blocks.get(count);
            found = block.findBreaks(flowcontext, context, calc, best);
            if (found) {
                best = flowcontext.getBestBreak();
System.out.println("best break: " + best);
                flowcontext = new FlowContext();
                context = new Context();

                LM child = best.getChildOf(this);
                if (child != null) {
                    // restart from the last break
                    count = blocks.indexOf(child) - 1;
                }

                breakList.add(best);
            }
        }
        // add null break which means the end
        // need to check the last break is not the end
        breakList.add(null);
        // break set contains information about the constraints
        // broken
        // the distance from optimum
    }

    public int distanceTo(BreakMark from, BreakMark lm) {
        int start = 0;
        if (from != null) {
            LM currentchild = from.getChildOf(this);
            if (currentchild != null) {
                start = blocks.indexOf(currentchild);
            }
        }
        int end = blocks.size();
        if (lm != null) {
            LM tochild = lm.getChildOf(this);
            if (tochild != null) {
                end = blocks.indexOf(tochild) + 1;
            }
        }

        int dist = 0;
        for (int count = start; count < end; count++) {
            BlockLM block = (BlockLM)blocks.get(count);
            dist += block.distanceTo(from, lm);
        }

        return dist;
    }

    public int getConstraint(BreakMark bm, boolean isLast) {
        return 0;
    }

    public int getPreviousConstraint() {
        return 0;
    }

    public void addAreas() {
        int rand = 1;
        Context context = new Context();
        BreakMark last = null;
        BlockLM lastLM = null;
        Color col = null;
        for (Iterator iter = breakList.iterator(); iter.hasNext();) {
            makeNewPage();
            BreakMark br = (BreakMark)iter.next();

            int start = 0;
            if (last != null) {
                LM currentchild = last.getChildOf(this);
                if (currentchild != null) {
                    start = blocks.indexOf(currentchild);
                }
            }
            int end = blocks.size();
            if (br != null) {
                LM tochild = br.getChildOf(this);
                if (tochild != null) {
                    end = blocks.indexOf(tochild) + 1;
                }
            }

            for (int count = start; count < end; count++) {
                BlockLM block = (BlockLM)blocks.get(count);

                if (lastLM != block) {
                    int r = (int)(Math.random() * 4) + 1;
                    while (rand == r) {
                        r = (int)(Math.random() * 4) + 1;
                    }
                    rand = r;
                    switch (rand) {
                        case 1:
                            col = Color.red;
                        break;
                        case 2:
                            col = Color.green;
                        break;
                        case 3:
                            col = Color.blue;
                        break;
                        case 4:
                            col = Color.orange;
                        break;
                    }
                    lastLM = block;
                }

                block.addAreas(context, last, br, col);
            }
            last = br;
            areaTree.addPage(curPage);
        }

    }

    public void addArea(Area area) {
        BlockParent bp = getFlowArea();
        bp.addBlock((Block)area);
    }

    protected BlockParent getFlowArea() {
        if (curSpan == null) {
            createBodyMainReferenceArea();
            createSpan(1);
            createFlow();
        }
        return curFlow;
    }

    private PageViewport makeNewPage() {
        curSpan = null;

        curPage = pager.createPage();

        curPage.setPageNumber("1");
        RegionViewport reg = curPage.getPage().getRegion(
                    RegionReference.BODY);
        curBody = (BodyRegion) reg.getRegion();
        int flowBPD = (int)reg.getViewArea().getHeight();
        return curPage;
    }

    private void createBodyMainReferenceArea() {
        curBody.setMainReference(new MainReference());
    }

    private Flow createFlow() {
        curFlow = new Flow();
        curFlow.setIPD(curSpan.getIPD());
        curSpan.addFlow(curFlow);
        return curFlow;
    }

    private void createSpan(int numCols) {
        curSpan = new Span(numCols);
        // get Width or Height as IPD for span
        curSpan.setIPD((int) curPage.getPage().getRegion(
                          RegionReference.BODY).getViewArea().getWidth());

        curBody.getMainReference().addSpan(curSpan);
        createFlow();
    }
}
