
package splitter;

import org.apache.fop.area.Area;


public interface LM {
    void addArea(Area area);
    LM getParentLM();
    int distanceTo(BreakMark from, BreakMark lm);
    int getConstraint(BreakMark bm, boolean isLast);
    int getPreviousConstraint();

    /**
     * Get the next break from a break.
     * Before the first break and after the last break is null.
     */
    //BreakMark getNextBreak(BreakMark current);

    //BreakMark getPreviousBreak(BreakMark current);
}

/*

Page columns
when doing page columns it will use findBreaks as normal
when it finds the distanceTo the page column LM will balance
the columns to find the distance of all columns combined and return this distance

Tables
the table-body (header, footer) use findBreaks
the table row however does it from the top using getNextBreak for each cell
from this break it can calculate the distance from the top of the table cell
using distanceTo in the table cell LM
The constraint for the break can be found only within the table cell
the breaks across all cells are combined to find a table row break

Lists
these are quite similar to tables


Footnotes/Before Floats
These are added to a context when finding the distanceTo the top level
(flow) can then add the resulting distance to the BPD of the body area

Side Floats
A side float is add to a context using distanceTo the parent reference area
retrieves these and considers them when calculating the distance to

----

It is not possible to say that the current line is x high therefore it
will add x to the BPD, it must always be calculated from the top down.

----

Once a set of breaks is found in the flow to create pages these breaks can be adjusted.
The getNextBreak and getPreviousBreak can be used to adjust the break
If the first page break in the flow is adjusted then the other breaks become
invalidated
lines or inlines that depend on the page or ipd may be changed so it will be
redone in the new context

The top level can then calculate the bpd distance and constraints directly
from the break


Spacing
The spacing is resolved when using distanceTo or addAreas
(could return boolean from addAreas to check if adding space after)





*/