
package splitter;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

// FOP
import org.apache.fop.datatypes.FODimension;
import org.apache.fop.layout.BorderAndPadding;
import org.apache.fop.layout.BackgroundProps;
import org.apache.fop.apps.FOPException;
import org.apache.fop.area.CTM;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.layoutmgr.AbstractLayoutManager;

import org.apache.fop.datatypes.FODimension;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Page;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.RegionReference;
import org.apache.fop.area.BodyRegion;

/**
 * Page has a height for flow area.
 */
public class PageLM {
    int flowHeight;
    int numColumns = 1;

    public PageLM() {
    }

    public int getHeight() {
        return flowHeight;
    }

    public int getColumnNumber() {
        return numColumns;
    }

    public PageViewport createPage() {
        int pageWidth = 400000;
        int pageHeight = 600000;

        Rectangle pageRefRect =
                new Rectangle(10000, 10000, 400000, 600000);

        Page page = new Page();

        // Set up the CTM on the page reference area based on writing-mode
        // and reference-orientation
        FODimension reldims = new FODimension(0, 0);

        CTM pageCTM = new CTM(10000, 10000);
        RegionViewport rvp = makeRegionViewport(reldims, pageCTM);
        rvp.setRegion(makeRegionReferenceArea(rvp.getViewArea()));
        page.setRegion(RegionReference.BODY, rvp);

        PageViewport pv = new PageViewport(page,
                    new Rectangle(0,0, pageWidth,pageHeight));
        return pv;
    }

    public RegionViewport makeRegionViewport(FODimension reldims, CTM pageCTM) {
        Rectangle2D relRegionRect = new Rectangle(10000, 10000, 200000, 500000);
        Rectangle2D absRegionRect = pageCTM.transform(relRegionRect);
        // Get the region viewport rectangle in absolute coords by
        // transforming it using the page CTM
        RegionViewport rv = new RegionViewport(absRegionRect);
        return rv;
    }

    public RegionReference makeRegionReferenceArea(Rectangle2D absRegVPRect) {

        BodyRegion body = new BodyRegion();
        CTM ctm = new CTM(30000, 20000);
        setRegionPosition(body, ctm);
        int columnCount = 1;
        body.setColumnCount(columnCount);

        int columnGap = 0;
        body.setColumnGap(columnGap);
        return body;
    }

    protected void setRegionPosition(RegionReference r, CTM ctm) {
        r.setCTM(ctm);
    }
}
