package splitter;

//
//  Splitter.java
//
import java.util.*;
import java.io.*;

import org.apache.fop.fo.FOUserAgent;
import org.apache.fop.area.AreaTree;
import org.apache.fop.area.AreaTreeModel;
import org.apache.fop.area.StorePagesModel;
import org.apache.fop.area.Title;
import org.apache.fop.render.pdf.PDFRenderer;
import org.apache.fop.render.Renderer;
import org.apache.fop.layout.FontInfo;

import org.apache.avalon.framework.logger.ConsoleLogger;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;

public class Splitter {
    FOUserAgent userAgent;
    Logger log;

    public static void main (String args[]) {
        // insert code here...
        Splitter split = new Splitter();
        split.createDocument();
    }
    
    public Splitter() {
    }
    
    public void createDocument() {
        try {
            OutputStream outputStream = new BufferedOutputStream(new FileOutputStream("test1.pdf"));
            Renderer renderer = new PDFRenderer();
            renderer.setUserAgent(getUserAgent());
            FontInfo fi = new FontInfo();
            renderer.setupFontInfo(fi);
            renderer.startRenderer(outputStream);

            AreaTree areaTree = new AreaTree();
            AreaTreeModel atModel = AreaTree.createRenderPagesModel(renderer);
            //this.atModel = new CachedRenderPagesModel(renderer);
            areaTree.setTreeModel(atModel);

            areaTree.startPageSequence(null);

            FlowLM flow = new FlowLM();
            flow.setAreaTree(areaTree);
            System.out.println("Create Blocks");
            flow.createBlocks();
            System.out.println("Find Breaks");
            flow.findBreaks();
            System.out.println("Add Areas");
            flow.addAreas();

            areaTree.endDocument();
            renderer.stopRenderer();
            outputStream.flush();
            outputStream.close();
        } catch (Exception e) {
            log.error("problem : " + e, e);
        }
    }

    private FOUserAgent getUserAgent() {
        if (userAgent == null) {
            userAgent = new FOUserAgent();
            userAgent.enableLogging(getLogger());
            userAgent.setBaseURL("");
        }
        return userAgent;
    }

    protected Logger getLogger() {
        if (log == null) {
            log = new ConsoleLogger(ConsoleLogger.LEVEL_INFO);
        }

        return log;
    }
}
