/*____________________________________________________________________________
	
	FreeAmp - The Free MP3 Player

	Portions Copyright (C) 2000 EMusic.com

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
	
	$Id: cddb.cpp,v 1.6 2000/06/21 13:34:36 ijr Exp $
____________________________________________________________________________*/

#include <assert.h>
#include <string>
#include <errno.h>
#include <windows.h>
#include <winbase.h>
using namespace std;

#include "config.h"
#include "errors.h"
#include "utility.h"

#include "cdini.h"
#include "cdpmo.h"
#include "cdini_proto.h"

#include "player.h"

extern "C"
{
   MetaDataFormat *Initialize(FAContext* context)
   {
      return new CDDB(context);
   }
}

CDDB::CDDB(FAContext* context):MetaDataFormat(context)
{
    use_cddb_message = true;
    parse_disc_artist = true;
    parse_track_artist = true;
}

CDDB::~CDDB()
{
}

bool CDDB::ReadMetaData(const char* url, MetaData* metadata)
{
    bool retvalue = false;

    assert(url);
    assert(metadata);

    if(url && metadata)
    {
        char *ext = strrchr(url, '.');
        if (!ext)
            return retvalue;

        if (strncasecmp(".CDA", ext, 4))
            return retvalue;

        Registry *pmoRegistry = m_context->player->GetPMORegistry();
        RegistryItem *pmo_item = NULL;
        int32 i = 0;

/*        while (NULL != (pmo_item = pmoRegistry->GetItem(i++))) {
            if (!strcmp("cd.pmo", pmo_item->Name())) {
                break;
            }
        }

        if (!pmo_item)
            return retvalue;

        CDPMO* pmo;

        pmo = (CDPMO*)pmo_item->InitFunction()(m_context);
        pmo->SetPropManager(m_context->props);
        pmo->Init(NULL);

        m_discinfo = ((CDPMO*)pmo)->GetDiscInfo();

        if (!m_discinfo->disc_present) {
            delete pmo;
            return retvalue;
        }

        m_discid = ((CDPMO*)pmo)->GetCDDBDiscID();
        if (!m_discid) {
	    delete pmo;
	    return retvalue;
	}

        m_total_tracks = m_discinfo->disc_total_tracks;

        struct disc_data data;
        if (cddb_read_disc_data(&data) < 0)
            return retvalue;
*/
        char *tracknumber = strrchr(url, '/');//DIR_MARKER);
        if (!tracknumber)
            tracknumber = (char *)url;
        else
            tracknumber++;

#ifdef WIN32
	while (!isdigit(tracknumber[0]))
	    tracknumber++;
#endif

        int m_track = atoi(tracknumber);

        if (m_track < 1)
            return retvalue;

        m_track--;
		char rootdir[3]="G:",
			volname[11],
			filesys[11];
//		long*  serialnum; 
		
		unsigned long  serial, maxcomplen,  flags;
		GetVolumeInformation(rootdir,volname,10,&serial,&maxcomplen,&flags,filesys,10);
//        metadata->SetAlbum(data.data_title);
		char buf[11];
		sprintf(buf,"%X",serial);
		char capt[128];
		GetPrivateProfileString(buf, "title", "", capt, 128, "cdplayer.ini");
        metadata->SetAlbum(capt);
		GetPrivateProfileString(buf, "artist", "", capt, 128, "cdplayer.ini");
        metadata->SetArtist(capt);
		char num[4];
		sprintf(num,"%d",m_track);
		GetPrivateProfileString(buf, num, "", capt, 128, "cdplayer.ini");
        metadata->SetTitle(capt);


/*        if (strlen(data.data_track[m_track].track_artist) > 0) 
            metadata->SetArtist(data.data_track[m_track].track_artist);
        else
            metadata->SetArtist(data.data_artist);
        metadata->SetTitle(data.data_track[m_track].track_name);
        metadata->SetComment(data.data_track[m_track].track_extended);
        metadata->SetTrack(m_track + 1);
        metadata->SetGenre(cddb_genre(data.data_genre));
        metadata->SetTime(m_discinfo->disc_track[m_track].track_length.minutes *
                          60 +  
                          m_discinfo->disc_track[m_track].track_length.seconds);
*/
        retvalue = true;

//	delete pmo;
    }
    return retvalue;
}

bool CDDB::WriteMetaData(const char* url, const MetaData& metadata)
{
    bool result = false;

    return result;
}
