# -*- coding: iso-8859-1 -*-
# -----------------------------------------------------------------------
#
import struct
import h222_psi
import dvb_desc

# Packet id as ETSI EN.300.468 Section 5.1.3
# See ETSI TS.102.232 Section 12.2 
CIT_PACKET_ID  = 0x12

# Table id as ETSI EN.300.468 Section 5.1.3
# See ETSI TS.102.232 Section 12.2 
CIT_TABLE_ID   = 0x77

# Syntax CIT as ETSI TS.102.232 Section 12.2 
class DVB_TS_CIT_version (h222_psi.H222_TS_PSI_version):
      def __init__(self, table_id):
          h222_psi.H222_TS_PSI_version.__init__(self, table_id)

          # Dictionary indexed by crid_ref
          self.CRIDs = {}
          return

      def __process_CIT_section (self, __section_data):
          # This section has syntax. Remove header and CRC
          section_data = __section_data[8:len(__section_data)-4]
          section_len  = len (section_data)

          self.service_id = self.table_id_extension

          if section_len < 5: return False
          (b1, b2, b3, b4, b5, ) = struct.unpack_from("5B", section_data, 0)
          pointer_data = 5
          self.transport_stream_id = ((b1 & 0x00ff) << 8) | b2
          self.original_network_id = ((b3 & 0x00ff) << 8) | b4
          prepend_strings_length   = b5

          self.prepend_strings = section_data[pointer_data:pointer_data+prepend_strings_length]
          pointer_data        += prepend_strings_length

          while pointer_data < section_len:
             (b6, b7, b8, b9, ) = struct.unpack_from("4B", section_data, pointer_data)
             pointer_data += 4
             crid_ref             = ((b6 & 0x00ff) << 8) | b7
             prepend_string_ref   = b8
             unique_string_length = b9

             format = "%is" % unique_string_length
             (crid_string, ) = struct.unpack_from(format, section_data, pointer_data)
             pointer_data += unique_string_length

             if prepend_string_ref != 0xff:
                # ToDo, prepend_strings
                pass

             self.CRIDs[crid_ref] = crid_string

          return True

      def process_subtable(self):
          if not self.section_syntax_indicator:
             _debug_("This subtable CIT should have syntax. Discard", DWARNING)
             return False

          for isec in range(self.last_section_number+1):
              if isec not in self.section_data: return False
              if not self.__process_CIT_section(self.section_data[isec]):
                 return False
          return True


class DVB_TVA_CIT ():
      def __init__(self, psi):
          array_tids = [CIT_TABLE_ID, ]
          array_pids = [CIT_PACKET_ID,]
          psi.define_psi_tables (array_tids, array_pids, DVB_TS_CIT_version, self.get_subtable_key)
          return

      def get_subtable_key(table, section):
          if len(section.data) < 8+4: return None

          service_id = section.table_id_extension
          (b1, b2, b3, b4) = struct.unpack_from("4B", section.data, 8)
          transport_stream_id = ((b1 & 0x00ff) << 8) | b2
          original_network_id = ((b3 & 0x00ff) << 8) | b4

          return (original_network_id, transport_stream_id, service_id)


class DVB_TVA ():
      def __init__(self, psi):
          self.cit = DVB_TVA_CIT (psi)
          return
