# -*- coding: iso-8859-1 -*-
# -----------------------------------------------------------------------
#
import struct
import binascii
import calendar

# As ETSI EN.300.468 Annex C
def mjd2utc(mjd, hour, minute, second):
    year  = int((mjd-15078.2)/365.25)
    month = int((mjd - 14956.1 - int(year*365.25))/30.6001)
    day   =  mjd - 14956 - int(year*365.25) - int(month*30.6001)
    if (month == 14) or (month == 15):
       year  += 1
       month -= 13
    else:
       month -= 1

    this_time = (1900+year, month, day, hour, minute, second, 0, 0, -1)
    return calendar.timegm(this_time)

# Return -1 if undefined, return 0 if invalid date
def parse_utc_time(buf):
    (t1, t2, bcd1, bcd2, bcd3) = struct.unpack_from("5B", buf, 0)

    # All bytes shall be 0xff if this time is undefined, return -1
    # See description of start_time in the EIT table for NVOD services
    if (t1 & t2 & bcd1 & bcd2 & bcd3) == 0xff: return -1

    modified_julian_date = ((t1 & 0x00ff) << 8) | t2
    hour   = 10*((bcd1 & 0x30)>>4) + (bcd1 & 0x0f)
    minute = 10*((bcd2 & 0x70)>>4) + (bcd2 & 0x0f)
    second = 10*((bcd3 & 0x70)>>4) + (bcd3 & 0x0f)
    try:
       return mjd2utc(modified_julian_date, hour, minute, second)
    except ValueError:
       _debug_("Error parsing UTC time: %s" % binascii.hexlify(buf[:5]), DERROR)
       return 0
