#include <unistd.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>
#include <stdio.h>

#include <signal.h>

FILE * fpEncoder ;

int main( int pnum, char * params[] )
{
  caddr_t pMaster ;
  char buffer[1024*64] ;
  int readBytes ;
  int fsize ;
  fd_set rfds ;
  struct timeval tv ;
  /* Number of timeouts before stopping */
  int bRun = 5 ;

  if ( pnum != 3 )
  {
     printf( "Usage: %s <file> <size>\n", params[0] ) ;
     printf( "  <file> name of the buffer-file.\n" ) ;
     printf( "  <size> size to allocate for the buffer-file.\n" ) ;
     exit(-1) ;
  }

  fsize = atoi( params[2] ) ;
  if ( fsize < 1024 ) 
  {
    printf( "A Buffer that small does not make much sense. Bailing out.\n" ) ;
    exit(0) ;
  }
  fflush( stdin ) ; fflush( stdout ) ;
  fpEncoder = popen( "mp1e -m3 -c/dev/video0 -p/dev/dsp2 -r14,100 -v", "r" ) ;
  if ( !fpEncoder )
  {
    fprintf( stderr, "popen failed\n" ) ;
  }
  while ( bRun > 0 )
  {
    /* Loop */
    int retval ;
    FD_ZERO( &rfds ) ;
    FD_SET( fileno(fpEncoder), &rfds ) ;    
    tv.tv_sec = 3 ;
    tv.tv_usec = 0 ;

    /* Wait for incoming data */
    retval = select( fileno(fpEncoder)+1, &rfds, NULL, NULL, &tv ) ;
    switch ( retval ) {
    case 1:
      if ( FD_ISSET( fileno(fpEncoder), &rfds ) ) 
      {
        readBytes = fread( buffer, 1, sizeof( buffer ), fpEncoder ) ;
        if ( readBytes > 0 ) 
        {
          printf( "\n%d Bytes read.\n", readBytes ) ;
          fflush( stdout ) ;
        }
        else if ( ( readBytes <= 0 ) && ( ferror( fpEncoder ) ) )
        {
          printf( "Read Error\n" ) ; fflush( stdout ) ;
          pclose(fpEncoder);
          exit(0) ;
        }
        else if ( ( readBytes <= 0 ) && ( feof( fpEncoder ) ) )
        {
          printf( "Read EOF\n" ) ;
          pclose(fpEncoder) ;
          exit(0) ;
        }
      }
      break ;
    case 0:
      printf( "No Data.\n" ) ; fflush( stdout ) ;
      /* Decrement Number of runs */
      --bRun ;
      break ;
    case -1:
      printf( "Select Error.\n" ) ; fflush( stdout ) ;
      bRun = 0 ;
      break ;
    default:
      printf( "This Point should never be reached.\n" ) ; fflush( stdout ) ;
      bRun = 0 ;
      break ;
    }
  }
  printf( "bye.\n" ) ;
  pclose( fpEncoder ) ;
}
