#!/usr/bin/python2.2

import fcntl, sys, os, struct
import threading
#import config
import util
import childapp
import signal
import popen2
import time

import rc

rc.get_singleton()

class Encoder:
    def __init__(self):
        self.thread = Encoder_Thread()
        self.thread.start()
        self.tuner_chidx = 0

    def TunerSetChannel(self, tuner_channel):
        for pos in range(len(config.TV_CHANNELS)):
            channel = config.TV_CHANNELS[pos]
            if channel[2] == tuner_channel:
                self.tuner_chidx = pos
                return
        print 'ERROR: Cannot find tuner channel "%s" in the TV channel listing' % tuner_channel
        self.tuner_chidx = 0
            
                
    def TunerGetChannelInfo(self):
        '''Get program info for the current channel'''

        tuner_id = config.TV_CHANNELS[self.tuner_chidx][2]
        chan_name = config.TV_CHANNELS[self.tuner_chidx][1]
        chan_id = config.TV_CHANNELS[self.tuner_chidx][0]
            
        channels = epg.get_guide().GetPrograms(start=time.time(),
                                               stop=time.time(), chanids=[chan_id])
            
        if channels and channels[0] and channels[0].programs:
            start_s = time.strftime('%H:%M', time.localtime(channels[0].programs[0].start))
            stop_s = time.strftime('%H:%M', time.localtime(channels[0].programs[0].stop))
            ts = '(%s-%s)' % (start_s, stop_s)
            prog_info = '%s %s' % (ts, channels[0].programs[0].title)
        else:
            prog_info = 'No info'
            
        return tuner_id, chan_name, prog_info
                     
    def TunerGetChannel(self):
        return config.TV_CHANNELS[self.tuner_chidx][2]            
            
    def TunerNextChannel(self):
        self.tuner_chidx = (self.tuner_chidx+1) % len(config.TV_CHANNELS)

    def TunerPrevChannel(self):
        self.tuner_chidx = (self.tuner_chidx-1) % len(config.TV_CHANNELS)

    def EventHandler(self,event):
        print '%s: %s app got %s event' % (time.time(), self.mode, event)
        if event == rc.CHUP or event == rc.CHDOWN:
            if event == rc.CHUP:
                self.TunerPrevChannel()
            else:
                self.TunerNextChannel()
            new_channel = self.TunerGetChannel()
            os.spawnlp(os.P_WAIT, 'v4lctl', '--device=/dev/video0', 'setchannel', new_channel)

    def Play(self, mode, tuner_channel=None, channel_change=0):
        if tuner_channel != None:            
            try:
                self.TunerSetChannel(tuner_channel)
            except ValueError:
                pass        
        self.thread.mode = 'play'
        self.thread.mode_flag.set()
        rc.app = self.EventHandler    

class TimeshifterApp(childapp.ChildApp):
    """
    class controlling the in and output from timeshift master
    """

    def __init__(self, app):
        childapp.ChildApp.__init__(self, app)


    def kill(self):
        # Use SIGINT instead of SIGKILL to make sure MPlayer shuts
        # down properly and releases all resources before it gets
        # reaped by childapp.kill().wait()
        childapp.ChildApp.kill(self, signal.SIGINT)


    def stdout_cb(self, str):
        print str

    def stderr_cb(self, str):
        print str


class Encoder_Thread(threading.Thread):

    def __init__(self):
        threading.Thread.__init__(self)

        self.mode      = 'idle'
        self.mode_flag = threading.Event()
        self.capturedev = '/dev/video0'
        self.audiodev = '/dev/dsp2'
        self.timeshiftfile = '/tmp/tsmaster.mpg'
        self.timeshiftsize = 1024*1024*32
#        self.command = './test %s %d' % (self.timeshiftfile, self.timeshiftsize)
        self.command = './testapp %s %d' % (self.timeshiftfile, self.timeshiftsize)
#        self.command   = 'mp1e -m3 -c%s -p%s -r14,100 -vv -o /tmp/test.mpg' % (self.capturedev, self.audiodev)
#        self.command = 'mp1e -m3 -c%s -p%s -r14,100 | ./master %s %i' % (self.capturedev, self.audiodev, self.timeshiftfile, self.timeshiftsize)
#        self.command = 'tail -f /root/compile/freevo/freevo.test > /tmp/test.mpg'
        self.app       = None

    def run(self):
        while 1:
            if self.mode == 'idle':
                self.mode_flag.wait()
                self.mode_flag.clear()

            elif self.mode == 'play':
                self.app = TimeshifterApp(self.command)
                while self.mode == 'play' and self.app.isAlive():
                    time.sleep(0.1)
                self.app.kill()
                self.mode = 'idle'
        print "App Killed.\n"


def test():
    # Tests
    t = Encoder()    
    t.Play()
#    t.mode = 'play'
#    t.mode_flag.set()
#    rc.app = self

if __name__ == '__main__':
  t = Encoder_Thread()
  t.start()
  t.mode = 'play'
  t.mode_flag.set()
