#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <time.h>

#include <directfb.h>


/* macro for a safe call to DirectFB functions */
#define DFBCHECK(x...) \
     {                                                                \
          err = x;                                                    \
          if (err != DFB_OK) {                                        \
               fprintf( stderr, "%s <%d>:\n\t", __FILE__, __LINE__ ); \
               DirectFBErrorFatal( #x, err );                         \
          }                                                           \
     }

int main( int argc, char *argv[] )
{
     IDirectFB              *dfb;
     IDirectFBDisplayLayer  *layer;
     IDirectFBDisplayLayer  *p_layer;
     
     IDirectFBWindow        *window1;
     IDirectFBWindow        *window2;
     DFBWindowID	    id;

     DFBDisplayLayerConfig  layer_config;
     DFBSurfacePixelFormat  	 pixelformat = DSPF_YV12;

     int err;
     char command[256], dfbmga_p[256];
     
     if (argc < 2) return -1;

     DFBCHECK(DirectFBInit( &argc, &argv ));
     DFBCHECK(DirectFBCreate( &dfb ));
     
     /* --------------------------------------------------------- */
     /* FOR BES UNCOMMENT 6 NEXT LINES AND COMMENT 3 LINES UNDER CRTC2 */ 
       DFBCHECK(dfb->GetDisplayLayer( dfb, 0, &p_layer ));       
       p_layer->SetCooperativeLevel( p_layer, DLSCL_EXCLUSIVE ); 
       p_layer->Release(p_layer);  
       DFBCHECK(dfb->GetDisplayLayer( dfb, 1, &layer ));
       layer->SetCooperativeLevel( layer, DLSCL_ADMINISTRATIVE );
       sprintf(dfbmga_p,"nocrtc2:bes:");
     /* --------------------------------------------------------- */

     /* --------------------------------------------------------- */
     /* FOR CRTC2 UNCOMMENT NEXT 3 LINES AND COMMENT 6 LINES UNDER BES */     
     //  DFBCHECK(dfb->GetDisplayLayer( dfb, 2, &layer ));
     //  layer->SetCooperativeLevel( layer, DLSCL_ADMINISTRATIVE );
     //  sprintf(dfbmga_p,"crtc2:nobes:");
     /* --------------------------------------------------------- */

     layer_config.flags = DLCONF_BUFFERMODE | DLCONF_PIXELFORMAT;
     layer_config.buffermode = DLBM_BACKSYSTEM;
     layer_config.pixelformat = pixelformat;

     layer->SetConfiguration( layer, &layer_config );
     
     layer->SetBackgroundColor(layer,0,0,0,255);
     layer->GetConfiguration( layer, &layer_config );
  
     DFBSurfaceDescription sdsc;
     DFBWindowDescription  desc;

     desc.flags = ( DWDESC_POSX | DWDESC_POSY |
                         DWDESC_WIDTH | DWDESC_HEIGHT );

     sdsc.width  = 300;
     sdsc.height = 200;
                                 
     desc.flags |= DWDESC_PIXELFORMAT;
     desc.pixelformat = pixelformat;
     desc.posx   = 20;
     desc.posy   = 120;
     desc.width  = 400;
     desc.height = 300;

     DFBCHECK( layer->CreateWindow( layer, &desc, &window2 ) );
     window2->SetOpacity( window2, 0xFF );
        

     desc.flags  = ( DWDESC_POSX | DWDESC_POSY |
                          DWDESC_WIDTH | DWDESC_HEIGHT);
     desc.posx   = 200;
     desc.posy   = 200;
     desc.width  = 512;
     desc.height = 145;          
     desc.flags |= DWDESC_PIXELFORMAT;
     desc.pixelformat = pixelformat;
                     

     DFBCHECK(layer->CreateWindow( layer, &desc, &window1 ) );

     window1->SetOpacity( window1, 0xFF );     
     window1->RequestFocus( window1 );
     window1->RaiseToTop( window1 );
     
     window2->GetID(window2,&id);
     sprintf(command,"/usr/local/bin/mplayer -fs -vo dfbmga:%swindow=%d %s &",dfbmga_p,id,argv[1]);    
     system(command);
     sleep(3);
     window1->GetID(window1,&id);
     sprintf(command,"/usr/local/bin/mplayer -fs -vo dfbmga:%swindow=%d %s &",dfbmga_p,id,argv[1]);
     system(command);
     while (1) 
       sleep(1);

     window2->Release( window2 );
     window1->Release( window1 );
     layer->Release( layer );
     dfb->Release( dfb );

     return 42;
}
