#!/usr/bin/env python
#JanakiRam
# usage : barcode-parse.py $inputFile $numberOfRowsToSkip $columnNumber $expecteFormat $output

import sys
import os.path
import re

sampleTCGAFormat = "PROJECT-TSS-PARTICIPANT-SAMPLE-PORTION-PLATE-CENTER"
if len(sys.argv) == 6:
	givenFile =open(sys.argv[1],"r")
	out = open(sys.argv[5], 'w')
	expectedFormat = sys.argv[4]
	numberOfRowsToSkip = int(sys.argv[2])
	columnNumberToParse = int(sys.argv[3])
	givenReadLines = givenFile.readlines()	
	out.write(givenReadLines[:numberOfRowsToSkip][0])
	expectedFormat = sampleTCGAFormat.split(expectedFormat.upper())[0]
	count = expectedFormat.count("-")
	def parseTCGA(barcode):
		try:
			barcodeIndentifiers = barcode.split("-",count+1)			
			return "-".join(barcodeIndentifiers[:count+1])
		except KeyError, e:
			print "TCGA/String is wrong, please enter valid TCGA/String"
	for line in givenReadLines[numberOfRowsToSkip:]:
		cols = line.split('\t')		
		cols[columnNumberToParse-1] = parseTCGA(cols[columnNumberToParse-1])
		out.write("\t".join(cols))
	givenFile.close()
else:
	print "Please enter valid arguments"
