/*-----------------------------------------------------------------
LOG
    GEM - Graphics Environment for Multimedia

    Adaptive threshold object

    Copyright (c) 1997-1999 Mark Danks. mark@danks.org
    Copyright (c) Gnther Geiger. geiger@epy.co.at
    Copyright (c) 2001-2002 IOhannes m zmoelnig. forum::fr::umlute. IEM. zmoelnig@iem.kug.ac.at
    Copyright (c) 2002 James Tittle & Chris Clepper
    For information on usage and redistribution, and for a DISCLAIMER OF ALL
    WARRANTIES, see the file, "GEM.LICENSE.TERMS" in this distribution.

-----------------------------------------------------------------*/

#ifndef INCLUDE_pix_freenect_H_
#define INCLUDE_pix_freenect_H_

#ifndef _EiC
//#include "cv.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <iostream>
#include <cmath>
#include <vector>

//#include "libfreenect.h"
#include "libfreenect.hpp"
 
#include "Base/GemConfig.h"
#include "Base/GemBase.h"
#include "Base/GemPixUtil.h"

//#include "Base/GemPixObj.h"
#include <pthread.h>


/*-----------------------------------------------------------------
-------------------------------------------------------------------
CLASS
    pix_freenect
    

KEYWORDS
    pix
    
DESCRIPTION
   
-----------------------------------------------------------------*/
class GEM_EXTERN pix_freenect : public GemBase
{
    CPPEXTERN_HEADER(pix_freenect, GemBase);

    public:

	    //////////
	    // Constructor
    	pix_freenect(t_float kinect_device_nr, t_float out_channel);
    	
    protected:
    	
    	//////////
    	// Destructor
    	virtual ~pix_freenect();

			virtual void	startRendering();
    	//////////
    	// Rendering 	
			virtual void 	render(GemState *state);
			
			virtual void 	postrender(GemState *state);
		
		  // Stop Transfer
			virtual void	stopRendering();
    	
	//////////
    	// Settings/Info
    	void				floatVideoModeMess(float videomode);
			void				floatDepthModeMess(float depthmode);
			void				floatChannelMess(float channel);
    	void	    	floatAngleMess(float angle);
    	void	    	floatLedMess(float led);
    	void	    	bangMess();


		
    	// Settings
        int x_angle;
        int x_led;
        int x_dim;
        
  int x_channel; //0 -> RGB Out, 1-> Depth Out
  
	freenect_video_format video_format;
	freenect_depth_format depth_format;

	int 		m_width;
	int			m_height;
	
	bool      m_rendering; // "true" when rendering is on, false otherwise

  
    	//////////
    	// The pixBlock with the current image
    	pixBlock    	m_image;
			//////////
			// The current image
			imageStruct     m_imageStruct;
	
    private:
    
    	//////////
    	// Static member functions
    	static void			floatVideoModeMessCallback(void *data, float videomode);
			static void			floatDepthModeMessCallback(void *data, float depthmode);
			static void			floatChannelMessCallback(void *data, float channel);
    	static void    	floatAngleMessCallback(void *data, float angle);
    	static void    	floatLedMessCallback(void *data, float led);
    	static void    	bangMessCallback(void *data);
    	


	/////////
	// IplImage needed

  

};

#endif	// for header file
