package javax.enterprise.deploy.spi.factories;

import javax.enterprise.deploy.spi.MockDeploymentManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;

public class MockDeploymentFactory implements DeploymentFactory {
    public boolean handlesURI(String uri) {
        // for the moment we accept all uri's
        return true;
    }

    public DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        return getDisconnectedDeploymentManager(uri);
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if ("return-null".equals(uri)) {
            return null;
        } else if ("throw-exception".equals(uri)) {
            throw new DeploymentManagerCreationException("Simulated Exception");
        } else {
            return new MockDeploymentManager();
        }
    }

    public String getDisplayName() {
        return null;
    }

    public String getProductVersion() {
        return null;
    }
}
