#!/bin/bash

# Carta Tecnica Regionale Numerica 1:5000
# Script per fondere le tavolette in un unico file che copra tutta la regione

if [ ! -d merged ]
then
  mkdir -p merged/GaussBoaga
fi

layers=(\
'1A000GH' '1A000IS' '1A000RO' '1A000NE' '1L000CR' '1L000CD' '1L000CI' '1L000CA' \
'1L000DI' '1L000II' '1L000SC' '1L000SP' '1L000SR' '1L000PS' '1L000FR' '1L000BR' \
'1P000DE' '1P000GO' '1P000GV' '1P000PQ' '1P000AU' '1T000VD' '1T000VP' '1T000OP' \
'1T000OS' '1T000DO' '2A000SE' '2A000SA' '2A000MC' '2A000TR' '2L000FR' '2L000FN' \
'2L000CR' '2L000CN' '2L000CS' '2L000SC' '2L000LA' '2L000PA' '2L000CA' '2L000DI' \
'2L000VA' '2L000MA' '2L000GU' '2L000AR' '2L000DF' '2L000CL' '2L000AC' '2P000VC' \
'2P000FO' '2P000SO' '2P000PO' '2P000PL' '2P000FA' '2P000NA' '2P000BR' '2P000BO' \
'2P000ID' '2T000TP' '2T000TS' '2T000TT' '2T000TI' '3A000BC' '3A000BI' '3A000VI' \
'3A000OV' '3A000FR' '3A000PI' '3A000BS' '3A000RI' '3L000LB' '3L000LC' '3L000BO' \
'3L000FA' '3L000FV' '3L000VA' '3L000LP' '3P000AL' '3P000VT' '3P000LA' '3P000LR' \
'3P000CE' '3P000PP' '3P000OL' '3P000FT' '3P000CP' '3P000AB' '3P000PM' '3P000FG' \
'3P000CO' '3P000PS' '3P000CA' '3P000RS' '4A000ED' '4A000IN' '4A000CU' '4A000AF' \
'4A000SM' '4A000EC' '4A000TP' '4A000SE' '4A000TE' '4A000BA' '4A000SC' '4A000TO' \
'4A000CE' '4A000IS' '4A000CA' '4A000SI' '4A000MO' '4A000EL' '4L000RU' '4L000PO' \
'4L000TR' '4L000BM' '4L000CO' '4L000CT' '4L000DV' '4L000SP' '4P000CF' '4P000SS' \
'4P000MT' '4P000CI' '4P000CR' '4P000TA' '4P000MS' '4P000CM' '4P000SR' '4P000CP' \
'4P000QG' '4P000QP' '4P000CC' '4P000FA' '4P000AR' '4P000SA' '4T000TC' '4T000CL' \
'4T000CN' '4T000EF' '5L000AU' '5L000SP' '5L000ST' '5L000ME' '5L000CA' '5L000CM' \
'5L000MU' '5L000SE' '5L000SO' '5L000MA' '5L000AS' '5L000PO' '5L000PA' '5L000FO' \
'5L000FC' '5L000FD' '5L000SF' '5L000TR' '5L000TC' '5L000AE' '5L000BS' '5L000IG' \
'5L000GS' '5L000TO' '5L000SI' '5P000CI' '5P000PV' '5P000IS' '5P000FS' '5T000VI' \
'5T000FE' '5T000TS' '5T000SS' '6A000RS' '6A000DI' '6A000DE' '6L000OL' '6L000MS' \
'6L000LE' '6L000TC' '6L000FS' '6L000IS' '6L000GR' '6L000CF' '6L000SC' '6P000TA' \
'6P000PL' '6P000TE' '6P000AN' '6P000EN' '6P000PS' '6T000SP' '6T000SS' '7L000MD' \
'7L000SC' '7L000MS' '7L000SE' '7L000SI' '8L000LC' '8L000LP' '8L000LR' '8L000LS' \
'8P000CC' '9P000G1' '9P000G2' '9P000G3' '9P000G4' '9P000RR' '9P000CA' '9P000FI' \
'9P000FF' '9P000PA' '9T000PN')

for element in $(seq 0 $((${#layers[@]} - 1)))
do
  layer=${layers[$element]}
  merged_name=merged/GaussBoaga/${layer}.shp
  echo $merged_name
   if [ ! -a $merged_name ]
   then
     for shp in `ls shapes/*/${layer}.shp`
     do
       if [ -a $merged_name ]
       then
         ogr2ogr -update -append ${merged_name} ${shp} -nln ${layer}
         echo "ogr2ogr -update -append ${merged_name} ${shp} -nln ${layer}"
       else
         ogr2ogr ${merged_name} ${shp}
         echo "ogr2ogr ${merged_name} ${shp}"
       fi
     done
   fi
done

